<?php

$sesameBaseUrl = rtrim(env('CORPUSPAROLE_SESAME_BASE_URL'),'/').'/';
$baseUrl = parse_url(env('APP_URL','http://localhost'), PHP_URL_PATH);
$baseUrl = ($baseUrl && strlen($baseUrl)>0)?$baseUrl:"/";

return [
    'sesame_base_url' => $sesameBaseUrl,
    'sesame_repository' => env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_repository_raw' => env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'max_load_retry' => env('CORPUSPAROLE_MAX_LOAD_RETRY', 5),
    'sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_update_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY').'/statements',
    'sesame_query_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'sesame_update_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW').'/statements',


    'cocoon_rdf_base_uri' => env('CORPUSPAROLE_COCOON_RDF_BASE_URI'),
    'cocoon_oaipmh_url' => env('CORPUSPAROLE_COCOON_OAIPMH_URL'),
    'cocoon_doc_id_base_uri' => 'http://purl.org/poi/crdo.vjf.cnrs.fr/',
    'cocoon_doc_pub_base_uri' => 'http://corpusdelaparole.huma-num.fr/corpus-app#/detail/',
    'cocoon_doc_id_base' => 'oai:crdo.vjf.cnrs.fr:',

    'corpus_id_scheme' => env('HANDLE_PREFIX').'/',
    'corpus_id_prefix' => env('HANDLE_PREFIX').'/crdo-',

    'corpus_doc_id_base_uri' => 'https://hdl.handle.net/'.env('HANDLE_PREFIX').'/',
    'corpus_doc_default_cc_rights' => 'http://creativecommons.org/licenses/by/4.0/',

    'edm_provider' => 'Corpus de la Parole',

    'easyrdf_http_client_timeout' => env('EASYRDF_HTTP_CLIENT_TIMEOUT', 1000),

    'corpus_discourse_type' => [
        "http://ark.bnf.fr/ark:/12148/cb12083158d" => "argumentation",
        "http://ark.bnf.fr/ark:/12148/cb119783362" => "bavardage",
        "http://ark.bnf.fr/ark:/12148/cb13319048g" => "chansons",
        "http://ark.bnf.fr/ark:/12148/cb11931724n" => "congrès et conférences",
        "http://ark.bnf.fr/ark:/12148/cb11936159v" => "contes",
        "http://ark.bnf.fr/ark:/12148/cb119317924" => "conversation",
        "http://ark.bnf.fr/ark:/12148/cb12481481z" => "dialogue",
        "http://ark.bnf.fr/ark:/12148/cb11948542x" => "discours",
        "http://ark.bnf.fr/ark:/12148/cb119341539" => "discussion",
        "http://ark.bnf.fr/ark:/12148/cb120502737" => "enquêtes linguistiques",
        "http://ark.bnf.fr/ark:/12148/cb11932135w" => "entretiens",
        "http://ark.bnf.fr/ark:/12148/cb11953414d" => "fables",
        "http://ark.bnf.fr/ark:/12148/cb11955657q" => "lecture à haute voix",
        "http://ark.bnf.fr/ark:/12148/cb11957378b" => "musique instrumentale",
        "http://ark.bnf.fr/ark:/12148/cb11937212q" => "narration",
        "http://ark.bnf.fr/ark:/12148/cb11946100d" => "paradigme (épistémologie)",
        "http://ark.bnf.fr/ark:/12148/cb119829234" => "questionnaires",
        "http://ark.bnf.fr/ark:/12148/cb119834877" => "récitation",
        "http://ark.bnf.fr/ark:/12148/cb11976851v" => "récits personnels",
        "http://ark.bnf.fr/ark:/12148/cb11949715t" => "réunions"
    ],

    'olac_discourse_type' => [
        'uri' => 'http://www.language-archives.org/OLAC/1.1/discourse-type',
        'values' => [
            [
                'code' => 'dialogue',
                'name' => 'Dialogue',
            ],

            [
                'code' => 'drama',
                'name' => 'Drama',
            ],

            [
                'code' => 'formulaic',
                'name' => 'Formulaic Discourse',
            ],

            [
                'code' => 'ludic',
                'name' => 'Ludic Discourse',
            ],
            [
                'code' => 'oratory',
                'name' => 'Oratory',
            ],

            [
                'code' => 'narrative',
                'name' => 'Narrative Discourse',
            ],

            [
                'code' => 'procedural',
                'name' => 'Procedural Discourse',
            ],

            [
                'code' => 'report',
                'name' => 'Report',
            ],

            [
                'code' => 'singing',
                'name' => 'Singing',
            ],

            [
                'code' => 'unintelligible_speech',
                'name' => 'Unintelligible Speech',
            ]
        ]
    ],

    'viaf_base_url' => 'http://viaf.org/viaf/',
    'viaf_cache_expiration' => 60*24*30,
    'viaf_max_ids' => 500,

    'lexvo_base_url' => 'http://lexvo.org/id/iso639-3/',
    'lexvo_cache_expiration' => 60*24*30,
    'lexvo_max_ids' => 50,
    'lexvo_sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_LEXVO_REPOSITORY'),

    'bnf_base_url' => 'http://data.bnf.fr/',
    'bnf_ark_base_url' => 'http://ark.bnf.fr/',
    'bnf_cache_expiration' => 60*24*30,
    'bnf_max_ids' => 5,
    'bnf_query_url' => 'http://data.bnf.fr/sparql',
    'bnf_completion_url' => 'http://data.bnf.fr/search-letter/',

    'bo_client_environment' => [
        "modulePrefix" => "bo-client",
        "podModulePrefix" => "bo-client/pods",
        "environment" => "production",
        "baseURL" => $baseUrl,
        "locationType" => "hash",
        "i18n" => ["defaultLocale" => "fr"],
        "EmberENV" => ["FEATURES"=>(object)[]], # to force json serialisation as object
        "APP" => [
            "bo-doc-viaf-autocomplete" => [
                "viafQueryUrl" => "http://viaf.org/viaf/AutoSuggest?query=",
                "viafBaseUrl" => "http://viaf.org/viaf/"
            ],
            'bo-doc-bnf-autocomplete' => [
                "bnfQueryUrl" => "${baseUrl}proxy/bnf/?term=",
                "bnfBaseUrl" => "http://data.bnf.fr/",
                "bnfSparqlUrl" => "${baseUrl}proxy/bnf-sparql"
            ],
            "LOG_RESOLVER" => true,
            "LOG_ACTIVE_GENERATION" => true,
            "LOG_TRANSITIONS" => true,
            "LOG_TRANSITIONS_INTERNAL" => true,
            "LOG_VIEW_LOOKUPS" => true,
            "name" => "bo-client",
            "version" => "0.0.0 "
        ],
        "contentSecurityPolicy" => [
            "default-src" => "'none'",
            "script-src" => "'self'",
            "font-src" => "'self'",
            "connect-src" => "'self' *",
            "img-src" => "'self'",
            "style-src" => "'self' *",
            "media-src" => "'self'"
        ],
        "contentSecurityPolicyHeader" => "Content-Security-Policy-Report-Only",
        "exportApplicationGlobal" => true
    ],

    'handle_host'         => env('HANDLE_HOST'),
    'handle_port'         => env('HANDLE_PORT', 8000),
    'handle_admin_id'     => env('HANDLE_ADMIN_ID'),
    'handle_prefix'       => env('HANDLE_PREFIX'),
    'handle_cert_or_pkey' => env('HANDLE_CERT_OR_PKEY'),
    'handle_password'     => env('HANDLE_PASSWORD'),

    'transcript_default_creator' => 'Corpus de la Parole',

];
