import Ember from 'ember';

const { getOwner } = Ember;

export default Ember.Component.extend({
  didInsertElement: function(){
    var _this = this;

    if (getOwner(this).lookup('controller:application').date !== null){
      this.highlightQuery(getOwner(this).lookup('controller:application').date);
    }

    var isMouseDown = false,
      isHighlighted;
    Ember.$("#chrono-table li").mousedown(function () {
      isMouseDown = true;
      Ember.$(this).toggleClass("highlighted");
      isHighlighted = Ember.$(this).hasClass("highlighted");
      _this.sendUpdate();
      return false; // prevent text selection
    }).mouseover(function () {
      if (isMouseDown) {
        Ember.$(this).toggleClass("highlighted", isHighlighted);
        _this.sendUpdate();
      }
    }).bind("selectstart", function () {
      return false;
    });

    Ember.$(document).mouseup(function () {
      isMouseDown = false;
    });
  },
  sendUpdate: function(){
    var dateQuery = [];
    Ember.$('.highlighted').map(function(index, elt) {
      dateQuery.push(parseInt(Ember.$(elt).parent().attr('id')) + parseInt(Ember.$(elt).html()));
    });
    this.sendAction('action', dateQuery);
  },
  highlightQuery: function(list){
    list.map(function(elt){
      var year = Math.floor(parseInt(elt)/10)*10;
      Ember.$("#"+year+" ."+(parseInt(elt)-year)).toggleClass("highlighted", true);
    });
  }
});
