import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['sorting-component'],

    filter: Ember.inject.service(),

    isAlphabetical: true,
    isPopularity: Ember.computed('isAlphabetical', function() { return !this.get('isAlphabetical'); }),

    minimum: Ember.computed('themes', function() { return Math.min(...this.themes.mapBy('count')); }),
    maximum: Ember.computed('themes', function() { return Math.max(...this.themes.mapBy('count')); }),

    more: true,

    themes: [],
    themesObserver: Ember.observer('themes.@each', function() {
        this.$('ul').on('scroll', Ember.run.bind(this, this.scrolling));
    }),
    scrolling: function(event) {
        if(Ember.$(event.target).scrollTop() !== 0 ) {
            if(Ember.$(event.target).scrollTop() + Ember.$(event.target).height() > Ember.$(event.target).get(0).scrollHeight - 50) {
                this.triggerAction({ action:'loadMore', target: this });
                Ember.$(event.target).off('scroll');
            }
        }
    },

    actions: {

        setQueryParameters: function(id) {
            this.get('filter').set('theme', id);
        },

        sortBy: function (type) {
            if(type === 'alphabetical') {
                this.set('isAlphabetical', true);
                this.sendAction('sort', 'alphabetical');
            } else {
                this.set('isAlphabetical', false);
                this.sendAction('sort', 'descending');
            }
            this.set('more', true);
        },

        loadMore: function() {
            this.sendAction('load');
            this.set('more', false);
        }

    }

});