import Ember from 'ember';

export default Ember.Controller.extend({

    queryParams: ['location', 'date', 'detail', {
        language: 'langue',
        discourse: 'discours',
        theme: 'thematique'
    }],

    date: [],
    discourse: null,
    language: null,
    location: null,
    theme: null,

    filter: Ember.inject.service(),
    setFilter: Ember.observer('date', 'discourse', 'language', 'location', 'theme', function(sender, key) {
        this.get('filter').set(key, this.get(key));
    }),
    filterObserver: Ember.observer('filter.date', 'filter.discourse', 'filter.language', 'filter.location', 'filter.theme', function(sender, key) {
        key = key.split('.').pop();
        this.set(key, this.get('filter').get(key));
    }),

    detail: null,

    dateIntervals: Ember.computed('date', function() {
        var intervals = [];
        this.get('date').forEach(function(date) {
            var intervalDate = false;
            intervals.forEach(function(interval) {
                if(interval.length && (interval.includes(date + 1) || interval.includes(date - 1))) {
                    interval.push(date);
                    intervalDate = true;
                }
            });
            if (!intervalDate) {
                intervals.push([date]);
            }
        });
        return intervals;
    }),

    currentId: null,
    currentItem: Ember.computed('currentId', function() {
        Ember.$(".result-item").toggleClass("playing", false);
        if (this.get('currentId') === null){
            return null;
        }
        Ember.$("div[id='" + this.get('currentId') + "']").toggleClass("playing", true);
        return this.store.findRecord('document', this.get('currentId'));
    }),

    modalItem: Ember.computed('detail', function() {
        return this.store.findRecord('document', this.get('detail'));
    }),

    actions: {

        deleteTag: function(key, value){
            var newValue = null;
            if (key === 'date'){
                newValue = [];
                Ember.$.each(this.get('date'), function(index, date){
                    if(!value.includes(date)) {
                        newValue.push(date);
                    }
                });
            }
            this.set(key, newValue);
        },

        changeDocument: function(docDirection){
            var direction = (docDirection === "next") ? 1 : -1;
            var currentObject = this.get("filteredDocuments").findBy('id', this.get("currentItem").get('id'));
            if ( currentObject !== 'undefined'){
                var index = this.get("filteredDocuments").indexOf(currentObject);
                if ( typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
                    return this.set('currentId', this.get("filteredDocuments").objectAt(index+direction).id);
                }
            }
            return this.set('currentId', this.get('filteredDocuments').get('firstObject').id);
        },
        play: function(item){
            this.set("currentId", item.id);
        },

        showMore: function(item){
            var domItem = Ember.$("#"+item.id.replace( /(:|\.|\[|\]|,)/g, "\\$1" ));
            if (domItem.hasClass("show-more")){
                domItem.toggleClass("show-more", false);
            } else{
                Ember.$(".result-item").toggleClass("show-more", false);
                domItem.toggleClass("show-more", true);
            }
        },

        toggleModal: function(item){
            if (typeof(item) !== 'undefined'){
                this.set("detail", item.id);
            } else {
                this.set("detail", null);
            }
        }

    }
});
