class sysconfig::rdf4j (
) inherits sysconfig::params {

    define create_lexvo_repository($unless = undef) {

        file { "lexvo_tmp_dir":
            path => "/tmp/lexvo",
            ensure => directory,
        }->
        file { "lexvo_data_archive":
            path => "/tmp/lexvo/lexvo.rdf.bz2",
            ensure => present,
            source => "puppet:///modules/sysconfig/rdf4j/lexvo_2013-02-09_cleaned.rdf.bz2",
        }->
        exec { "lexvo_data_extract":
            command => "/usr/bin/bunzip2 /tmp/lexvo/lexvo.rdf.bz2",
            unless => $unless,
            creates => "/tmp/lexvo/lexvo.rdf"
        }->
        file { "lexvo_commands":
            path => "/tmp/lexvo/console_commands.txt",
            ensure => present,
            source => "puppet:///modules/sysconfig/rdf4j/console_commands.txt",
        }->
        exec { "lexvo_console":
            command => "/opt/rdf4j/bin/console.sh < /tmp/lexvo/console_commands.txt",
            cwd => "/opt/rdf4j/bin",
            creates => "/opt/rdf4j/.lexvo_loaded",
            unless => $unless
        }->
        exec { "lexvo_data_archive_delete":
            command => "/usr/bin/rm -fr /tmp/lexvo"
        }->
        file { "/opt/rdf4j/.lexvo_loaded":
            ensure => present,
            content => "",
        }

        #->
        # File <| title == "lexvo_tmp_dir" |> {
        #     path => "/tmp/lexvo",
        #     ensure => absent,
        # }
    }

    file { "/tmp/rdf4j":
        ensure => directory,
    }->
    package { "unzip":
        ensure => present
    }->
    archive { 'rdf4j-2.1.1':
        ensure => present,
        url => "http://www.eclipse.org/downloads/download.php?file=/rdf4j/eclipse-rdf4j-2.1.1-sdk.zip&r=1",
        checksum => false,
        extension => "zip",
        follow_redirects => true,
        strip_components => 1,
        target => "/tmp/rdf4j",
        purge_target => true,
        src_target => '/tmp',
        timeout => 500,
    }->
    file { "/opt/rdf4j":
        ensure => directory,
        source => "file:///tmp/rdf4j/eclipse-rdf4j-2.1.1",
        recurse => true,
        purge => true
    }->
    file { [ "/var/lib/rdf4j",
             "/var/lib/rdf4j/data" ]:
        ensure => directory,
        owner => "tomcat",
        group => "tomcat",
        require => Package['tomcat']
    }->
    augeas { "etc-sysconfig/tomcat":
        context => "/files/etc/sysconfig/tomcat",
        changes => [
            "set JAVA_OPTS '\"-Dinfo.aduna.platform.appdata.basedir=/var/lib/rdf4j/data -Xms512m -Xmx512m\"'"
        ],
        notify => Service['tomcat']
    }->
    exec { "undeploy-rdf4j-tomcat":
         command => "/usr/bin/rm -f /var/lib/tomcat/webapps/{openrdf,rdf4j}-*.war && /bin/sleep 10",
         notify => Service['tomcat'],
         path => "/usr/bin:/bin"
    }->
    exec { "copy-rdf4j-tomcat":
         command => "/usr/bin/cp /opt/rdf4j/war/*.war /var/lib/tomcat/webapps",
         notify => Service['tomcat']
    }->
    create_lexvo_repository { "create-lexvo-repository":
        unless => '/usr/bin/curl -s -f -I http://localhost:8080/rdf4j-server/repositories/lexvo/statements'
    }


#
#download archive

#put war at the right place

#create the repository if not exists

}
