@inject('version', 'version')
<!DOCTYPE html>
<html lang="en">
<head>
    @section('meta')
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    @show
    <title>@yield('title','Trésors de la Parole')</title>

    <link rel="shortcut icon" href="{{ asset('/img/favicon.ico') }}" type="image/vnd.microsoft.icon" />

    @section('css-assets')
    <link href="{{ asset('/css/app.css') }}" rel="stylesheet">

    <!-- Fonts -->
    <link href="{{ asset('/css/fonts.css')}}" rel='stylesheet' type='text/css'>
    @show

</head>
<body>
    <header id="navbar" role="banner" class="navbar container-fluid navbar-default col-lg-12">
    @section('header')
        <div class="row">
            <div class="culture-header container">
                <a class="culture-header-link" target="_blank" href="http://www.culturecommunication.gouv.fr">
                    <img class="front-header-logo" src="{{ asset('/img/marianne-2.png') }}" alt="Ministère de la Culture et Communication">
                    <span>
                    Un site du ministère de la Culture
                </span>
                </a>
            </div>
        </div>
        <div class="container">
            <div class="navbar-header">
                <a class="logo navbar-btn pull-left" href="/" title="Accueil">
                    <img src="{{ asset('/img/logo_corpus.png') }}" alt="Accueil">
                </a>
                <a class="name navbar-brand" href="/" title="Accueil">Trésor de la parole</a>
            </div>
            <div class="navbar-collapse collapse">
                @yield('nav')
            </div>
        </div>
    @show
    </header>

    <div class="container-fluid">
    @yield('content')
    </div>

    <footer class="footer container container-non-responsive">
        @section('footer')
        <section class="partenariat">
            <div class="row">
                <div class="col-xs-2 logo-marianne">
                    <a href="http://www.culturecommunication.gouv.fr/" title="Ministère de la Culture">
                        <img src="{{ asset('/img/marianne.jpg') }}" class="img-responsive" alt="Logo du Ministère de la Culture">
                    </a>
                </div>
                <div class="col-xs-8">
                    <div class="region region-footer">
                        <section id="block-menu-menu-footer-menu" class="block block-menu clearfix">
                            <div class="row">
                                <div class="col-md-12">
                                    <ul id="footer_menu" class="menu nav">
                                        <li class="first leaf"><a href="/contactez-nous" title="">Contact</a></li>
                                        <li class="leaf"><a href="/credits">Crédits</a></li>
                                        <li class="last leaf"><a href="/mentions-legales">Mentions légales</a></li>
                                        <li><a href="/sitemap">Plan du site</a></li>
                                    </ul>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
                <div class="col-xs-2 iri-cnrs">
                    <label>En partenariat avec</label>
                    <a href="http://www.iri.centrepompidou.fr/" title="IRI">
                        <img src="{{ asset('/img/logoIRI.jpg') }}" alt="Logo dde l'IRI" width="75" height="50">
                    </a>
                    <a href="http://www.cnrs.fr/" title="CNRS">
                        <img src="/img/logoCNRS.jpg" alt="Logo du CNRS" width="75" height="50">
                        <img src="{{ asset('/img/logoCNRS.jpg') }}" alt="Logo du CNRS" width="75" height="50">
                    </a>
                </div>
            </div>
        </section>

        <div class="row">
            <div class="col-md-12 copyright-culture">version {{ $version->version() }} ©&nbsp;Ministère de la Culture</div>
        </div>
        @show
    </footer>

    @section('js-assets')
    <!-- Scripts -->
    <script src="{{ asset('/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('/js/vendor/bootstrap.js') }}"></script>
    @show

</body>
</html>
