import Ember from 'ember';

export default Ember.Service.extend(Ember.Evented, {

    items: [],
    item: null,
    model: null,
    transcript: null,

    window: false,
    playing: false,
    progress: 0, // In Milliseconds
    videoscreen: false,

    modelObserver: Ember.observer('model', function() {
        this.toggleVideoscreen(this.get('model').get('video'));
    }),

    displayAdditionalInformation: function(el) {
        if(el === 'video') {
            console.log('toggleVideoscreen');
            this.toggleVideoscreen();
        } else {
            if(this.get('window') !== el) {
                this.displayMetadata(el);
            } else {
                this.displayMetadata(false);
            }
        }
    },

    displayMetadata: function(el) {
         if(typeof el !== 'undefined') {
            this.set('window', el);
        } else {
            this.set('window', false);
        }
    },

    toggleVideoscreen: function(state) {
        if(typeof state === 'undefined') {
            this.set('videoscreen', !this.get('videoscreen'));
        } else {
            this.set('videoscreen', state);
        }        
    },

    init: function() {
        this.on('reset', Ember.run.bind(this, this.get('reset')));
    },

    setProgress: function(time) {
        this.set('progress', time);
    },

    select: function (id) {
        this.set('item', id);
    },

    play: function(id) {
        this.select(id);
        this.set('playing', true);
    },

    pause: function() {
        this.set('playing', false);
    },

    reset: function(id) {
        this.set('item', id);
    }
});
