<?php
namespace CorpusParole\Libraries\Mappers;

use CorpusParole\Libraries\CocoonUtils;

use EasyRdf\Graph;
use EasyRdf\Literal;
use EasyRdf\Resource;


abstract class CocoonContentRdfMapper extends CocoonAbstractRdfMapper {


    protected function mapResource($res, $outputGraph) {
        $this->mapMainGraph($res, $outputGraph);
        //map collection
        $this->mapCollections($res);
    }

    abstract protected function mapWebResources($res, $outputGraph);

    protected function mapMainGraph($res, $outputGraph) {
        $this->mapAggregationNode($res, $outputGraph);
        $this->mapProvidedCHO($res, $outputGraph);
        $this->mapWebResources($res, $outputGraph);
    }

    /**
     * Build the aggregation node
     */
    protected function mapAggregationNode($res, $outputGraph) {
        $resId = CocoonUtils::getIdFromUri($this->getResourceBaseId($res));
        $resUri = CocoonUtils::getCorpusUriFromId($resId);

        $aggregationNode = $outputGraph->resource($resUri, 'ore:Aggregation');

        $aggregationResource = $aggregationNode->addResource('edm:aggregatedCHO', $this->getResourceBaseId($res));

        $aggregationNode->addLiteral('edm:provider', config('corpusparole.edm_provider'), 'fr');

        $publishersInputs = $res->all($this->inputGraph->resource('http://purl.org/dc/elements/1.1/publisher'));
        if(count($publishersInputs) == 0) {
            $provider = Literal::create(config('corpusparole.edm_provider'), 'fr');
        }
        else {
            $provider = $publishersInputs[0];
            //TODO: if this is a resource, get id from it (viaf)
        }
        $aggregationNode->add('edm:dataProvider', $provider);

        $aggregationNode->addResource('edm:isShownAt', CocoonUtils::getCocoonPubUrl($resId));

        $master = null;
        $masterList = $res->all($this->inputGraph->resource('http://crdo.risc.cnrs.fr/schemas/master'));
        if(count($masterList)==0) {
            $masterList = $res->all($this->inputGraph->resource('http://purl.org/dc/terms/isFormatOf'));
        }
        if(count($masterList)>0) {
            $aggregationNode->add('edm:isShownBy', $masterList[0]);
        }

        $license = $res->get('dc:license');
        $matches = [];

        if( ($license instanceof Resource) &&
            (preg_match('/http\:\/\/creativecommons\.org\/licenses\/([a-z-]+)\/[\d\.]+\//', $license->getUri(), $matches) > 0) ) {
            $license = "http://creativecommons.org/licenses/$matches[1]/4.0/";
        }
        else {
            $license = config('corpusparole.corpus_doc_default_cc_rights');
        }

        $aggregationNode->addResource('edm:rights', $license);
    }

    protected function propertyTypeMap($providedCHOResource, $prop, $value) {
        $providedCHOResource->add($prop, $value);
    }

    protected function propertyReferenceCorrectMap($providedCHOResource, $prop, $value) {
        $providedCHOResource->add('http://purl.org/dc/terms/references', $value);
    }

    /**
     * Build the provided CHO.
     */
    private function mapProvidedCHO($res, $outputGraph) {

        $providedCHOResource = $outputGraph->resource($this->getResourceBaseId($res), 'edm:ProvidedCHO');

        $this->addCHOResourceProperties($providedCHOResource, $res, $outputGraph);

        $this->addDateProperties($providedCHOResource, $res, $outputGraph);
        $this->addSpatialProperties($providedCHOResource, $res, $outputGraph);

    }

    protected function addCHOResourceProperties($providedCHOResource, $res, $outputGraph) {
        $this->applyPropertiesToRes($res, $providedCHOResource, [
            ['http://purl.org/dc/terms/tableOfContents', null],
            ['http://purl.org/dc/elements/1.1/description', null],
            ['http://purl.org/dc/elements/1.1/language', null],
            ['http://purl.org/dc/elements/1.1/publisher', null],
            ['http://purl.org/dc/elements/1.1/rights', null],
            ['http://purl.org/dc/elements/1.1/type', 'propertyTypeMap'],
            ['http://purl.org/dc/terms/license', null],
            ['http://purl.org/dc/elements/1.1/subject', null],
            ['http://purl.org/dc/elements/1.1/title', null],
            ['http://purl.org/dc/elements/1.1/language', null],
            ['http://purl.org/dc/terms/accessRights', 'propertyTrimMap'],
            ['http://purl.org/dc/terms/extent', null],
            ['http://purl.org/dc/terms/isPartOf', null],
            ['http://purl.org/dc/terms/abstract', null],
            ['http://purl.org/dc/elements/1.1/source', null],
            ['http://purl.org/dc/terms/medium', null],
            ['http://purl.org/dc/terms/alternative', null],
            ['http://purl.org/dc/terms/bibliographicCitation', null],
            ['http://purl.org/dc/elements/1.1/identifier', null],
            ['http://purl.org/dc/terms/references', null],
            ['http://purl.org/dc/elements/1.1/reference', 'propertyReferenceCorrectMap'],
            ['http://purl.org/dc/elements/1.1/coverage', null],
            ['http://purl.org/dc/elements/1.1/relation', null],
            ['http://purl.org/dc/elements/1.1/creator', null],
            ['http://www.language-archives.org/OLAC/1.1/annotator', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/author', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/compiler', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/consultant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/data_inputter', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/depositor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/developer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/editor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/illustrator', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/interpreter', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/interviewer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/participant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/performer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/photographer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/recorder', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/researcher', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/research_participant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/responder', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/signer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/singer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/speaker', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/sponsor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/transcriber', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/translator', 'propertyOlacRoleMap'],
        ]);

    }

    protected function addDateToWebResource($sourceRes, $targetRes) {

        $this->applyPropertiesToRes($sourceRes, $targetRes, [
            ['http://purl.org/dc/terms/created', null],
            ['http://purl.org/dc/terms/issued', null],
        ]);
    }

}
