import Ember from 'ember';

export default Ember.Controller.extend({

    queryParams: ['location', 'langue', 'discours', 'date', 'thematique', 'detail'],
    location: null,
    langue: null,
    discours: null,
    date: [],
    thematique: null,
    detail: null,

    dateIntervals: Ember.computed('date', function() {
        var intervals = [];
        this.get('date').forEach(function(date) {
            var intervalDate = false;
            intervals.forEach(function(interval) {
                if(interval.length && (interval.includes(date + 1) || interval.includes(date - 1))) {
                    interval.push(date);
                    intervalDate = true;
                }
            });
            if (!intervalDate) {
                intervals.push([date]);
            }
        });
        return intervals;
    }),

    currentId: null,
    currentItem: Ember.computed('currentId', function() {
        Ember.$(".result-item").toggleClass("playing", false);
        if (this.get('currentId') === null){
            return null;
        }
        Ember.$("div[id='" + this.get('currentId') + "']").toggleClass("playing", true);
        return this.store.findRecord('document', this.get('currentId'));
    }),

    modalItem: Ember.computed('detail', function() {
        return this.store.findRecord('document', this.get('detail'));
    }),

    filteredDocuments: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
        var location = this.get('location');
        var langue = this.get('langue');
        var discours = this.get('discours');
        var date = this.get('date');
        var thematique = this.get('thematique');

        var documents = this.get('model');

        if (location) {
            documents = documents.filterBy('spatial', location);
        }
        if (langue) {
            documents = documents.filterBy('language', langue);
        }
        if (discours) {
            documents = documents.filterBy('type', discours);
        }
        if (date.length > 0) {
            var temp = documents;
            documents.map(function(elt){
                if (date.indexOf(elt.get('created')) === -1){
                    temp = temp.without(elt);
                }
            });
            documents = temp;
        }
        if (thematique) {
            documents = documents.filterBy('thematique', thematique);
        }
        return documents;
    }),

    actions: {

        deleteTag: function(key, value){
            var newValue = null;
            if (key === 'date'){
                newValue = [];
                Ember.$.each(this.get('date'), function(index, date){
                    if(!value.includes(date)) {
                        newValue.push(date);
                    }
                });
            }
            this.set(key, newValue);
        },

        changeDocument: function(docDirection){
            var direction = (docDirection === "next") ? 1 : -1;
            var currentObject = this.get("filteredDocuments").findBy('id', this.get("currentItem").get('id'));
            if ( currentObject !== 'undefined'){
                var index = this.get("filteredDocuments").indexOf(currentObject);
                if ( typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
                    return this.set('currentId', this.get("filteredDocuments").objectAt(index+direction).id);
                }
            }
            return this.set('currentId', this.get('filteredDocuments').get('firstObject').id);
        },
        play: function(item){
            this.set("currentId", item.id);
        },

        showMore: function(item){
            var domItem = Ember.$("#"+item.id.replace( /(:|\.|\[|\]|,)/g, "\\$1" ));
            if (domItem.hasClass("show-more")){
                domItem.toggleClass("show-more", false);
            } else{
                Ember.$(".result-item").toggleClass("show-more", false);
                domItem.toggleClass("show-more", true);
            }
        },

        toggleModal: function(item){
            if (typeof(item) !== 'undefined'){
                this.set("detail", item.id);
            } else {
                this.set("detail", null);
            }
        }

    }
});
