import Ember from 'ember';

export default Ember.Route.extend({

    model() {
        return this.store.findAll('document');
    },

    serializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            return value;
        }
        return '' + value;
    },

    deserializeQueryParam: function(value, urlKey) {
        if (urlKey === 'date') {
            var arr = [];
            for (var i = 0; i < value.length; i++) {
                arr.push(parseInt(value[i]));
            }
            return arr;
        }
        return value;
    },

    actions: {

        willTransition: function() {
            var _this = this;
            var queryParams = {};
            this.controller.get('queryParams').map(function(elt){
                queryParams[elt] = _this.controller.get(elt);
            });
            this.transitionTo({ queryParams: queryParams });
        },

        didTransition: function() {
            this._super(...arguments);
            Ember.$('body').removeClass((this.controller.get('currentPath') || '').replace(/\//g, '-').dasherize());
            Ember.run.once(this, function() {
                Ember.$('body').addClass((this.controller.get('currentPath') ||'').replace(/\//g, '-').dasherize());
            });
        }

    }

});
