<?php

use Mockery as m;

use EasyRdf\Resource;
use EasyRdf\Literal;
use CorpusParole\Services\ViafResolverException;

/**
 *
 */
class LanguageControllerTest extends TestCase {

    private $ES_QUERY;

    public function setUp() {
        $this->ES_QUERY = [
            'index' => 'corpus',
            'body' => [
                "size" => 0,
                "query" => [ "match_all" => (object) null ],
                "aggs" => [
                    "languages" => [
                        "terms" => [ "field" => "language", "order" => [ "_count" => "desc" ], "size" => 2147483647 ]
                    ]
                ]
            ]
        ];
        parent::setup();
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {

        Es::shouldReceive('search')
                ->once()
                ->with($this->ES_QUERY)
                ->andReturn(json_decode('{
    "took": 92,
    "timed_out": false,
    "_shards": {
        "total": 1,
        "successful": 1,
        "failed": 0
    },
    "hits": {
        "total": 3373,
        "max_score": 0.0,
        "hits": []
    },
    "aggregations": {
        "languages": {
            "doc_count_error_upper_bound": 0,
            "sum_other_doc_count": 0,
            "buckets": [{
                "key": "http://lexvo.org/id/iso639-3/fra",
                "doc_count": 1669
            }, {
                "key": "http://lexvo.org/id/iso639-3/gsw",
                "doc_count": 851
            }, {
                "key": "http://lexvo.org/id/iso639-3/bre",
                "doc_count": 403
            }]
        }
    }
}', true));

        $response = $this->get('/api/v1/stats/languages/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(['languages' => [
                'http://lexvo.org/id/iso639-3/fra' => 1669,
                'http://lexvo.org/id/iso639-3/gsw' => 851,
                'http://lexvo.org/id/iso639-3/bre' => 403,
            ]]);
    }
}
