/* jshint node: true */

module.exports = function(environment) {
  var rootURL = '/';
  var ENV = {
    modulePrefix: 'bo-client',
    podModulePrefix: 'bo-client/pods',
    environment: environment,
    rootURL: rootURL,
    locationType: 'auto',
    i18n : {
      defaultLocale: 'fr'
    },
    EmberENV: {
      FEATURES: {
        // Here you can enable experimental features on an ember canary build
        // e.g. 'with-controller': true
      },
      EXTEND_PROTOTYPES: {
        // Prevent Ember Data from overriding Date.parse.
        Date: false
      }
    },

    APP: {
      // Here you can pass flags/options to your application instance
      // when it is created
      'bo-doc-viaf-autocomplete' : {
          viafQueryUrl: "http://viaf.org/viaf/AutoSuggest?query=",
          viafBaseUrl: "http://viaf.org/viaf/",
      },
      'bo-doc-bnf-autocomplete' : {
          bnfQueryUrl: rootURL + "proxy/bnf/?term=",
          bnfBaseUrl: "http://data.bnf.fr/",
          bnfSparqlUrl: rootURL + "proxy/bnf-sparql"
      }
    }
  };

  if (environment === 'development') {
    // ENV.APP.LOG_RESOLVER = true;
    // ENV.APP.LOG_ACTIVE_GENERATION = true;
    // ENV.APP.LOG_TRANSITIONS = true;
    // ENV.APP.LOG_TRANSITIONS_INTERNAL = true;
    // ENV.APP.LOG_VIEW_LOOKUPS = true;
  }

  if (environment === 'test') {
    // Testem prefers this...
    ENV.rootURL = '/';
    ENV.locationType = 'none';

    // keep test console output quieter
    ENV.APP.LOG_ACTIVE_GENERATION = false;
    ENV.APP.LOG_VIEW_LOOKUPS = false;

    ENV.APP.rootElement = '#ember-testing';
  }

  if (environment === 'production') {
    ENV.locationType = 'hash';
  }

  return ENV;
};
