import Ember from 'ember';

export default Ember.Component.extend({
    classNames: ['player-component'],

    player: Ember.inject.service(),
    popcorn: null,

    head: 0,
    remaining: 0,

    isFirst: false,
    isLast: false,

    item: Ember.computed('player.model', function() {
        return this.get('player').get('model');
    }),

    modelLoaded: Ember.observer('player.model', function() {
        var items = this.get('player').get('items');
        var index = items.indexOf(this.get('player').get('item'));
        this.set('isFirst', index === 0);
        this.set('isLast', index === items.length - 1);
    }),

    init: function() {
        this._super(...arguments);
        this.get('player');
    },

    didInsertElement: function() {
        this.set('popcorn', Popcorn('#popcorn-audio'));
        this.get('popcorn').on('timeupdate', Ember.run.bind(this, this.get('onProgress')));
    },

    onProgress: function(event) {
        var currentTime = this.get('popcorn').currentTime();
        var duration = this.get('popcorn').duration();
        this.$('.bar .value').width(currentTime * 100 / duration + '%');
        this.set('head', currentTime);
        this.set('remaining', duration - currentTime);
    },

    actions: {

        play: function() {
            if(this.get('player').get('playing')) {
                this.get('popcorn').pause();
            } else {
                this.get('popcorn').play();
            }
            this.get('player').set('playing', !this.get('player').get('playing'));
        },

        backward: function() {
            console.log('backward');
        },

        forward: function() {
            console.log('forward');
        }

    }
});
