import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['playlist-component'],

    filter: Ember.inject.service(),
    player: Ember.inject.service(),

    documents: Ember.computed('model', 'filter.location', 'filter.language', 'filter.discourse', 'filter.date', 'filter.theme', function() {
        var self = this;
        var documents = this.get('model');
        if (this.get('filter.date').length > 0) {
            var copy = documents;
            documents.map(function(document) {
                if (self.get('filter.date').indexOf(document.get('created')) === -1){
                    copy = copy.without(document);
                }
            });
            documents = copy;
        }
        if (this.get('filter.discourse')) {
            documents = documents.filterBy('type', this.get('filter.discourse'));
        }
        if (this.get('filter.language')) {
            documents = documents.filterBy('language', this.get('filter.language'));
        }
        if (this.get('filter.location')) {
            documents = documents.filterBy('spatial', this.get('filter.location'));
        }
        if (this.get('filter.theme')) {
            documents = documents.filterBy('thematique', this.get('filter.theme'));
        }
        return documents;
    }),

    didRender: function() {
        this._super(...arguments);
        this.$().find('ul').height(Ember.$('.corpus-app-wrapper').outerHeight() - (Ember.$('.filter-component').outerHeight() + this.$().find('h2').outerHeight()));
    },

    actions: {

        setItem: function(id) {
            this.get('player').set('item', id);
            this.get('player').set('items', this.get('documents').map(function(document) {
                return document.get('id');
            }));
        }

    }

});
