import * as constants from 'corpus-common-addon/utils/constants';

import ResolverService from 'corpus-common-addon/services/resolver-service';

export default ResolverService.extend({

    storeKeyBase: 'viaf',
    apiPath:  '/api/v1/viaf/',
    resDocRoot: 'viafids',

    init() {
        this._super(...arguments);
        console.log("VIAF", this);
    },

    processId: function(id) {
        var viafId = id;
        if(id.startsWith(constants.VIAF_BASE_URL)) {
            viafId = id.slice(constants.VIAF_BASE_URL.length);
        }
        return viafId;
    },

    getReturnDictKey: function(id) { return id; }

});
