import Ember from 'ember';
import layout from '../templates/components/doc-literal';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',
  value: Ember.computed('url', function() {
    var url = this.get('url');
    if(typeof url === 'string') {
      return url;
    }
    else if (typeof url === 'object' && !Array.isArray(url) && 'value' in url) {
      return url['value'];
    }
    else {
      return null;
    }
  }),
  lang: Ember.computed('url', function() {
    var url = this.get('url');
    if (typeof url === 'object' && !Array.isArray(url) && 'lang' in url) {
      return url['lang'];
    }
    else {
      return null;
    }
  }),
  datatype: Ember.computed('url', function() {
    var url = this.get('url');
    if (typeof url === 'object' && !Array.isArray(url) && 'datatype' in url) {
      return url['datatype'];
    }
    else {
      return null;
    }
  })

});
