/* global require, module */
var EmberApp = require('ember-cli/lib/broccoli/ember-app');
var pickFiles = require('broccoli-static-compiler');


module.exports = function(defaults) {

  var app = new EmberApp(defaults, {
    outputPaths: {
      vendor: {
        js: '/assets/bo-client-vendor.js',
        css: '/assets/bo-client-vendor.css'
      }
    },
    fingerprint: {
      enabled: false
    },
    //storeConfigInMeta: false,
    // Add options here
    emberCliFontAwesome: {
      useScss: true
    },
    sassOptions: {
      includePaths: [
        'app/styles',
      ],
    }
  });

  // bootstrap
  app.import('bower_components/bootstrap-sass/assets/javascripts/bootstrap.js');
  var bootstrapFonts = pickFiles('bower_components/bootstrap-sass/assets/fonts', {
    srcDir: '/',
    destDir: '/fonts'
  });

  app.import({
      development: 'bower_components/urijs/src/URI.js',
      production:  'bower_components/urijs/src/URI.min.js'
  });
  app.import('vendor/shims/urijs.js', {
    exports: {
      'urijs': [ 'default' ]
    }
  });
  app.import({
      development: 'bower_components/store/store.js',
      production:  'bower_components/store/store.min.js'
  });
  app.import('vendor/shims/store.js', {
    exports: {
      'store': ['default']
    }
  });

  // app.import('../src/vendor/bower_components/bootstrap-sass/assets/fonts/bootstrap/glyphicons-halflings-regular.woff', {
  //   destDir: 'fonts'
  // })

  // Use `app.import` to add additional libraries to the generated
  // output files.
  //
  // If you need to use different assets in different
  // environments, specify an object as the first parameter. That
  // object's keys should be the environment name and the values
  // should be the asset to use in that environment.
  //
  // If the library that you are including contains AMD or ES6
  // modules that you would like to import into your application
  // please specify an object with the list of modules as keys
  // along with the exports of each module as its value.

  return app.toTree(bootstrapFonts);
};
