<?php

$sesameBaseUrl = rtrim(env('CORPUSPAROLE_SESAME_BASE_URL'),'/').'/';
$baseUrl = parse_url(env('APP_URL','http://localhost'), PHP_URL_PATH);
$baseUrl = ($baseUrl && strlen($baseUrl)>0)?$baseUrl:"/";

return [
    'sesame_base_url' => $sesameBaseUrl,
    'sesame_repository' => env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_repository_raw' => env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'max_load_retry' => env('CORPUSPAROLE_MAX_LOAD_RETRY', 5),
    'sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_update_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY').'/statements',
    'sesame_query_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'sesame_update_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW').'/statements',


    'cocoon_rdf_base_uri' => env('CORPUSPAROLE_COCOON_RDF_BASE_URI'),
    'cocoon_oaipmh_url' => env('CORPUSPAROLE_COCOON_OAIPMH_URL'),
    'cocoon_doc_id_base_uri' => 'http://purl.org/poi/crdo.vjf.cnrs.fr/',
    'cocoon_doc_pub_base_uri' => 'http://cocoon.huma-num.fr/exist/crdo/meta/',
    'cocoon_doc_id_base' => 'oai:crdo.vjf.cnrs.fr:',

    'corpus_doc_id_base_uri' => 'http://purl.org/poi/corpusdelaparole.huma-num.fr/',
    'corpus_doc_default_cc_rights' => 'http://creativecommons.org/licenses/by/4.0/',

    'edm_provider' => 'Corpus de la Parole',

    'easyrdf_http_client_timeout' => env('EASYRDF_HTTP_CLIENT_TIMEOUT', 1000),

    'olac_discourse_type' => [
        'uri' => 'http://www.language-archives.org/OLAC/1.1/discourse-type',
        'values' => [
            [
                'code' => 'dialogue',
                'name' => 'Dialogue',
            ],

            [
                'code' => 'drama',
                'name' => 'Drama',
            ],

            [
                'code' => 'formulaic',
                'name' => 'Formulaic Discourse',
            ],

            [
                'code' => 'ludic',
                'name' => 'Ludic Discourse',
            ],
            [
                'code' => 'oratory',
                'name' => 'Oratory',
            ],

            [
                'code' => 'narrative',
                'name' => 'Narrative Discourse',
            ],

            [
                'code' => 'procedural',
                'name' => 'Procedural Discourse',
            ],

            [
                'code' => 'report',
                'name' => 'Report',
            ],

            [
                'code' => 'singing',
                'name' => 'Singing',
            ],

            [
                'code' => 'unintelligible_speech',
                'name' => 'Unintelligible Speech',
            ]
        ]
    ],

    'viaf_base_url' => 'http://viaf.org/viaf/',
    'viaf_cache_expiration' => 60*24*30,

    'lexvo_base_url' => 'http://lexvo.org/id/iso639-3/',
    'lexvo_cache_expiration' => 60*24*30,
    'lexvo_sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_LEXVO_REPOSITORY'),

    'bo_client_environment' => [
        "modulePrefix" => "bo-client",
        "podModulePrefix" => "bo-client/pods",
        "environment" => "production",
        "baseURL" => $baseUrl,
        "locationType" => "hash",
        "i18n" => ["defaultLocale" => "fr"],
        "EmberENV" => ["FEATURES"=>(object)[]], # to force json serialisation as object
        "APP" => [
            "bo-doc-viaf-autocomplete" => [
                "viafQueryUrl" => "http://viaf.org/viaf/AutoSuggest?query=",
                "viafBaseUrl" => "http://viaf.org/viaf/"
            ],
            "LOG_RESOLVER" => true,
            "LOG_ACTIVE_GENERATION" => true,
            "LOG_TRANSITIONS" => true,
            "LOG_TRANSITIONS_INTERNAL" => true,
            "LOG_VIEW_LOOKUPS" => true,
            "name" => "bo-client",
            "version" => "0.0.0 "
        ],
        "contentSecurityPolicy" => [
            "default-src" => "'none'",
            "script-src" => "'self'",
            "font-src" => "'self'",
            "connect-src" => "'self' *",
            "img-src" => "'self'",
            "style-src" => "'self' *",
            "media-src" => "'self'"
        ],
        "contentSecurityPolicyHeader" => "Content-Security-Policy-Report-Only",
        "exportApplicationGlobal" => true
    ]
];
