<?php

namespace CorpusParole\Providers;

use Config;

use Illuminate\Support\ServiceProvider;

class BnfServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('CorpusParole\Services\BnfResolverInterface', function($app) {
            $sparqlClient = $app->make('EasyRdf\Sparql\Client', [config('corpusparole.bnf_query_url'), null]);
            return $app->make('CorpusParole\Services\BnfResolver', [$sparqlClient,]);
        });
    }
}
