import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['playlist-component'],

    filter: Ember.inject.service(),
    player: Ember.inject.service(),

    documents: Ember.computed('model', 'filter.location', 'filter.language', 'filter.discourse', 'filter.date', 'filter.theme', function() {
        return this.get('model');
    }),

    documentsLoaded: Ember.observer('documents', function() {
        this.get('player').set('items', this.get('documents').map(function(document) {
            return document.get('id');
        }));
        if(this.get('player').get('items').length && this.get('player').get('playing') === false) {
            this.get('player').set('item', this.get('player').get('items')[0]);    
        }
    }).on('init'),

    init: function() {
        this._super(...arguments);
    },

    didRender: function() {
        this._super(...arguments);
        this.$().find('ul').height(Ember.$('.corpus-app-wrapper').outerHeight() - (Ember.$('.filter-component').outerHeight() + this.$().find('h2').outerHeight()));
    },

    actions: {

        select: function(id) {
            this.get('player').select(id);
        },

        play: function(id) {
            this.get('player').play(id);
        },

        pause: function() {
            this.get('player').pause();
        },

        displayTranscript: function() {
            this.get('player').displayAdditionalInformation('transcript');
        },

        displayNotice: function(id) {
            if(this.get('player').get('item') === id) {
                this.get('player').displayMetadata('notice');
            } else {
                if(this.get('notice') !== id) {
                    this.set('notice', id);
                } else {
                    this.set('notice', null);
                }
            }

        }

    }

});
