import Ember from 'ember';
import store from 'store';

import ENV from 'bo-client/config/environment';

export default Ember.Service.extend({
  constants: Ember.inject.service(),
  _getStoreKey: function(id) {
    return 'lexvo:'+id;
  },
  getName: function(id) {
    var lexvoId = id;
    if(id.startsWith(this.get('constants').LEXVO_BASE_URL)) {
      lexvoId = id.slice(this.get('constants').LEXVO_BASE_URL.length);
    }
    var storeKey = this._getStoreKey(id);
    var namePromise = null;

    var name = store.get(storeKey);
    if(!name) {
      //TODO: handle error !!!
      namePromise = this.queryName(lexvoId)
        .then( function(response) {
            return store.set(storeKey, response);
        });
    }
    else {
      namePromise = new Ember.RSVP.Promise(function(resolve/*, reject*/) {
        resolve(name);
      });
    }
    return namePromise;
  },
  // make the query for the name.
  // return a Promise
  queryName: function(id) {
    return new Ember.RSVP.Promise(function(resolve, reject) {
      Ember.$.ajax({
        //TODO Configuration ?
        url: ENV.baseURL.replace(/\/$/,"") + "/api/v1/lexvo/"+id,
        success: function(lexvoDoc) {
          var names = lexvoDoc.lexvoids;
          resolve((id in names)?names[id]:null);
        },
        error: function(req, status, error) {
          reject(status + ":" + error);
        }
      });
    }.bind(this));
  }
});
