module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var documentsRouter = express.Router();


  var documentList = [{
    "id": "crdo-09-CAYCHAX_SOUND",
    "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-09-CAYCHAX_SOUND",
    "title": "ALLOc : Caychax : Parabole",
    "language": "http://lexvo.org/id/iso639-3/gsw",
    "modified": "2010-10-25T18:16:38+02:00",
    "publishers": [
      "Équipe de Recherche en Syntaxe et Sémantique",
      "Bases, corpus, langage"
    ],
    "contributors": [
      {
        "name": null,
        "url": "http://viaf.org/viaf/56666014",
        "role": "http://www.language-archives.org/OLAC/1.1/data_inputter"
      },
      {
        "name": "LDOR",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/depositor"
      },
      {
        "name": "Thésaurus Occitan",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/depositor"
      },
      {
        "name": "Équipe de Recherche en Syntaxe et Sémantique",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/editor"
      },
      {
        "name": "Bases, corpus, langage",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/editor"
      },
      {
        "name": null,
        "url": "http://viaf.org/viaf/91792187",
        "role": "http://www.language-archives.org/OLAC/1.1/interviewer"
      },
      {
        "name": null,
        "url": "http://viaf.org/viaf/51700729",
        "role": "http://www.language-archives.org/OLAC/1.1/researcher"
      },
      {
        "name": "Alazet, Pierre",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/speaker"
      },
      {
        "name": "Del Duca, Jeanne",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/transcriber"
      }
    ],
    "mediaArray": {
      "http://cocoon.huma-num.fr/data/archi/144792_09-CAYCHAX_22km.wav": {
        "url": "http://cocoon.huma-num.fr/data/archi/144792_09-CAYCHAX_22km.wav",
        "format": "audio/x-wav",
        "extent": "PT03M18S",
        "extent_ms": 198000,
        "master": false
      },
      "http://cocoon.huma-num.fr/data/archi/masters/144792.wav": {
        "url": "http://cocoon.huma-num.fr/data/archi/masters/144792.wav",
        "format": "audio/x-wav",
        "extent": "PT03M18S",
        "extent_ms": 198000,
        "master": true
      },
      "http://cocoon.huma-num.fr/data/archi/mp3/144792_09-CAYCHAX_44k.mp3": {
        "url": "http://cocoon.huma-num.fr/data/archi/mp3/144792_09-CAYCHAX_44k.mp3",
        "format": "audio/mpeg",
        "extent": "PT03M18S",
        "extent_ms": 198000,
        "master": false
      },
      "http://cocoon.huma-num.fr/exist/crdo/thesoc/oc/crdo-09-CAYCHAX.xhtml": {
        "url": "http://cocoon.huma-num.fr/exist/crdo/thesoc/oc/crdo-09-CAYCHAX.xhtml",
        "format": "application/xhtml+xml",
        "extent": null,
        "extent_ms": null,
        "master": false
      },
      "http://cocoon.huma-num.fr/exist/crdo/thesoc/oc/crdo-09-CAYCHAX.xml": {
        "url": "http://cocoon.huma-num.fr/exist/crdo/thesoc/oc/crdo-09-CAYCHAX.xml",
        "format": "application/xml",
        "extent": null,
        "extent_ms": null,
        "master": false
      }
    }
  },
  {
    "id": "crdo-ALA_177",
    "uri": "http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-ALA_177",
    "title": "Atlas Linguistique et ethnographique de l'Alsace - Enquêtes linguistiques - Cleebourg: 04",
    "language": "http://lexvo.org/id/iso639-3/fra",
    "modified": "2014-12-01T18:34:43+01:00",
    "publishers": [
      "Atlas linguistiques, cultures et parlers régionaux de France"
    ],
    "contributors": [
      {
        "name": null,
        "url": "http://viaf.org/viaf/9122216",
        "role": "http://www.language-archives.org/OLAC/1.1/depositor"
      },
      {
        "name": null,
        "url": "http://viaf.org/viaf/61542329",
        "role": "http://www.language-archives.org/OLAC/1.1/interviewer"
      },
      {
        "name": "Informateur 1",
        "url": null,
        "role": "http://www.language-archives.org/OLAC/1.1/speaker"
      },
      {
        "name": null,
        "url": "http://viaf.org/viaf/61542329",
        "role": "http://www.language-archives.org/OLAC/1.1/transcriber"
      }
    ],
    "mediaArray": {
      "http://cocoon.huma-num.fr/data/ala/ALA_177.mp3": {
        "url": "http://cocoon.huma-num.fr/data/ala/ALA_177.mp3",
        "format": "audio/mpeg",
        "extent": "PT23M53S",
        "extent_ms": 1433000,
        "master": false
      },
      "http://cocoon.huma-num.fr/data/ala/masters/ALA_177.wav": {
        "url": "http://cocoon.huma-num.fr/data/ala/masters/ALA_177.wav",
        "format": "audio/x-wav",
        "extent": "PT23M53S",
        "extent_ms": 1433000,
        "master": true
      },
      "http://cocoon.huma-num.fr/data/ala/ALA_177_22km.wav": {
        "url": "http://cocoon.huma-num.fr/data/ala/ALA_177_22km.wav",
        "format": "audio/x-wav",
        "extent": "PT23M53S",
        "extent_ms": 1433000,
        "master": false
      }
    }
  }];

  documentsRouter.get('/', function(req, res) {
    res.send({
      'documents': documentList,
    });
  });

  documentsRouter.post('/', function(req, res) {
    res.status(201).end();
  });

  documentsRouter.get('/:id', function(req, res) {

    var docRes = _.find(documentList, 'id', req.params.id);
    if(docRes) {
      res.send({'document': docRes});
    } else {
      res.status(404).send('Not found');
    }

  });

  documentsRouter.put('/:id', function(req, res) {
    res.send({
      'document': {
        id: req.params.id
      }
    });
  });

  documentsRouter.delete('/:id', function(req, res) {
    res.status(204).end();
  });

  app.use('/api/v1/documents', documentsRouter);
};
