class sysconfig::elasticsearch (
    $es_host     = hiera('sysconfig::params::es_host', $sysconfig::params::es_host),
    $es_port     = hiera('sysconfig::params::es_port', $sysconfig::params::es_port),
    $es_instance = hiera('sysconfig::params::es_instance', $sysconfig::params::es_instance),
) inherits sysconfig::params {

    notify {'elasticsearch': name => "\$es_host : ${es_host}, \$es_port : ${es_port}, \$es_instance : ${es_instance}", withpath => true }


    exec { "systemd_restart_${es_instance}":
        command     => "/bin/systemctl start elasticsearch-${es_instance}",
        refreshonly => true,
    }

    exec { "systemd_enable_${es_instance}":
        command     => "/bin/systemctl enable elasticsearch-${es_instance}",
        refreshonly => true,
    }

    class { '::elasticsearch':
      manage_repo  => true,
      autoupgrade => true,
      repo_version => '5.x',
      status => 'unmanaged',
    }->
    elasticsearch::instance { $es_instance: }->
    file { '$es_instance jvm.options':
        path => "/etc/elasticsearch/${es_instance}/jvm.options",
        source => "puppet:///modules/sysconfig/elasticsearch/jvm.options",
        owner => 'root',
        group => 'elasticsearch',
        mode => '0750'
    } ->
    file { '$es_instance log4j2.properties':
        path => "/etc/elasticsearch/${es_instance}/log4j2.properties",
        source => "puppet:///modules/sysconfig/elasticsearch/log4j2.properties",
        owner => 'root',
        group => 'elasticsearch',
        mode => '0750'
    } ->
    file { '$es_instance logging.xml':
        path => "/etc/elasticsearch/${es_instance}/logging.xml",
        ensure => absent
    } ->
    file {  '$es_instance sysconfig':
        path => "/etc/sysconfig/elasticsearch-${es_instance}",
        source => "puppet:///modules/sysconfig/elasticsearch/elasticsearch-${es_instance}",
        owner => 'root',
        group => 'elasticsearch',
        mode => '0750'

    } ->
    file { '$es_instance service file':
        path => "/usr/lib/systemd/system/elasticsearch-${es_instance}.service",
        source => "puppet:///modules/sysconfig/elasticsearch/elasticsearch-${es_instance}.service",
        owner => 'root',
        group => 'root',
        mode => '0750',
        notify => [Exec['systemctl-daemon-reload'], Exec["systemd_enable_${es_instance}"], Exec["systemd_restart_${es_instance}"]]
    }
}
