<?php
namespace CorpusParole\Libraries\RdfModel;

use CorpusParole\Libraries\RdfModel\RdfModelDelta;
use EasyRdf\Resource;

/**
 *
 */
class RdfModelResource extends Resource {

    public function __construct($uri, $graph = null) {
        parent::__construct($uri, $graph);
        $this->uri = $uri;
    }

    protected $deltaList = [];
    protected $currentDelta = null;
    protected $uri = null;

    protected function additionalDeltaLists() {
        return [];
    }

    public function isDirty() {
        return $this->deltaCount()>0;
    }

    public function deltaCount() {
        $deltaList = $this->getDeltaList();
        return is_null($deltaList)?0:count($deltaList);
    }

    public function getDeltaList() {
        $deltaList = is_null($this->deltaList)?[]:$this->deltaList;
        $additionalDeltaLists = $this->additionalDeltaLists();
        if(!empty($additionalDeltaLists)) {
            array_unshift($additionalDeltaLists, $deltaList);
            $deltaList = call_user_func_array('array_merge', $additionalDeltaLists);
        }
        return $deltaList;
    }

    public function getUri() {
        return $this->uri;
    }

    public function getCurrentDelta() {
        return $this->currentDelta;
    }

    public function startDelta() {
        $this->currentDelta = new RdfModelDelta($this->getGraph()->getUri());
        array_push($this->deltaList, $this->currentDelta);
        return $this->currentDelta;
    }

    protected function setSimpleProperty($baseNode, $property, $oldValue, $newValue) {
        $delta = $this->startDelta();
        $baseNode->delete($property, $oldValue);
        $delta->getDeletedGraph()->add($baseNode, $property, $oldValue);
        $baseNode->add($property, $newValue);
        $delta->getAddedGraph()->add($baseNode, $property, $newValue);
    }


}
