import Ember from 'ember';

export default Ember.Component.extend({
  // storage: Ember.inject.service(),
  didInsertElement: function(){
    var _this = this;
    // console.log("maps : ", AmCharts.maps);
    //
    // console.log('test: ', this.get("query"));
    //
    // this.get("sounds").map(item => {
  	// 	console.log(item.get('title'));
  	// });

    var continentsDataProvider;

    var franceDataProvider = {
        mapVar: AmCharts.maps.franceDepartmentsLow,
        getAreasFromMap:true,

        areas: this.initArea(AmCharts.maps.franceDepartmentsLow)
    };

    var worldDataProvider = {
        map: "worldLow",
        getAreasFromMap: true,
        images: [{
            id: "backButton",
            label: "Back to continents map",
            rollOverColor: "#CC0000",
            labelRollOverColor: "#CC0000",
            useTargetsZoomValues: true,
            left: 30,
            bottom: 30,
            labelFontSize: 15,
            selectable: true
        }],
        areas: this.initArea(AmCharts.maps.worldLow, franceDataProvider)
    };


    var continentsDataProvider = {
        map: "continentsLow",

        areas: [{
            id: "africa",
            linkToObject: worldDataProvider,
            color: "#7CACAE",
            passZoomValuesToTarget: true
        }, {
            id: "asia",
            linkToObject: worldDataProvider,
            color: "#E0EEEF",
            passZoomValuesToTarget: true
        }, {
            id: "australia",
            linkToObject: worldDataProvider,
            color: "#E0EEEF",
            passZoomValuesToTarget: true
        }, {
            id: "europe",
            linkToObject: worldDataProvider,
            color: "#2D7073",
            passZoomValuesToTarget: true
        }, {
            id: "north_america",
            linkToObject: worldDataProvider,
            color: "#B0D1D3",
            passZoomValuesToTarget: true
        }, {
            id: "south_america",
            linkToObject: worldDataProvider,
            color: "#E0EEEF",
            passZoomValuesToTarget: true
        }]

    };


    var map = AmCharts.makeChart("mapdiv", {
        type: "map",


        areasSettings: {
            autoZoom: true,
            rollOverOutlineColor: "#000000",
            selectedOutlineColor: "#CC0000",
            selectedColor: "green",
            color: "#E0EEEF"
        },

        dataProvider: continentsDataProvider

    });

    function handleGoHome() {
        map.dataProvider = continentsDataProvider;
        map.validateNow();
    }
    function handleMapObjectClick (event) {
        if (event.mapObject.id == "backButton") {
            handleGoHome();
        }
        _this.sendAction('action', event.mapObject.title);
    }

    // monitor when home icon was clicked and also go to continents map
    map.addListener("homeButtonClicked", handleGoHome);
    map.addListener("clickMapObject", handleMapObjectClick);
  },
  initArea: function(area, dataProvider){
    var _this = this;

    var areaList = [];
    var count = {};
    area.svg.g.path.map(function(elt, index){
      var length = _this.get("sounds").filterBy("spatial", elt.title).toArray().length;
      if (length > 0)
        count[elt.id]= length;
    });
    area.svg.g.path.map(function(elt, index){

      areaList.push({
        id: elt.id,
        linkToObject: (elt.id === "FR" ? dataProvider : ""),
        color: ((typeof(count[elt.id]) === "undefined") ? "#E0EEEF" : "#2D7073"),
        autoZoom: (elt.id === "FR" ? true : false),
        selectable: true,
        passZoomValuesToTarget: false
      });
    });
    return areaList;
  }
});
