/* jshint node:true */
/* eslint-env node */
/* eslint global-require: 0, no-magic-numbers: 0 */

module.exports = function(app) {
  const express = require('express');
  const _ = require('lodash');

  const v1ViafRouter = express.Router();

  const viafMappings = require('../fixtures/viaf');

  v1ViafRouter.get('/:id', function(req, res) {
    const idList = req.params.id.split(',');

    res.send({
      viafids: _.reduce(idList, function(r, id) {
        r[id] = (id in viafMappings) ? viafMappings[id] : null;

        return r;
      }, {})
    });
  });

  app.use('/api/v1/resolvers/viaf', v1ViafRouter);
};
