#!/usr/bin/env bash

pushd /vagrant/root/var/www/corpusdelaparole/corpus-back/ > /dev/null
echo "---> Launching composer"
php composer.phar install --ignore-platform-reqs -o
echo "---> Composer done"
echo "---> Clear cache"
php artisan cache:clear
echo "---> Clear config cache"
php artisan config:clear
echo "---> Clear route"
php artisan route:clear
echo "---> Clear views"
php artisan view:clear
echo "---> put application in maintenance"
php artisan down

popd > /dev/null

mkdir -p /vagrant/dist
pushd /vagrant/dist > /dev/null
echo "---> Launching packaging"
rm -f *.rpm

popd > /dev/null

version=$(grep -oP "\'version\'\s*=>\s*\'\K[\.0-9]+(?=\')" /vagrant/root/var/www/corpusdelaparole/corpus-back/config/version.php)
version=${version:-0.0.0}

fpm \
    --verbose \
    -a all \
    -s dir \
    -t rpm \
    -C /vagrant/root \
    -d httpd \
    -d php56 \
    -d mariadb-server \
    -d mariadb \
    --name corpusdelaparole \
    --version "$version" \
    --iteration $(date +%s) \
    --description "Corpus de la parole source rpm" \
    --url "http://corpusdelaparole.huma-num.fr" \
    --rpm-user apache \
    --rpm-group apache \
    --directories /var/www/corpusdelaparole \
    --after-install /vagrant/post_install.sh \
    --after-remove /vagrant/post_uninstall.sh \
    --after-upgrade /vagrant/post_upgrade.sh \
    --before-upgrade /vagrant/pre_upgrade.sh \
    .

echo "---> Packaging done"
