import Ember from 'ember';
import d3 from 'd3';
import ENV from 'app-client/config/environment';
import _ from 'lodash/lodash';
import URI from 'urijs';

export default Ember.Component.extend({

    classNames: ['discourses-component'],

    constants: Ember.inject.service(),
    filter: Ember.inject.service(),

    discourseObserver: Ember.observer('filter.discourse', function() {
        Ember.$('.item').removeClass("selected");
        if(this.get('filter').get('discourse') !== null) {
            this.get('filter').get('discourse').forEach(function(e) {
                Ember.$('.item[data-id="' + e + '"]').addClass("selected");
            });
        }

    }).on('init'),

    didRender: function() {
        var self = this;
        var baseURL = (ENV.APP.backRootURL || ENV.rootURL).replace(/\/$/,"")+'/api/v1/stats';
        var url = URI(baseURL+"/stats/discourses").search(this.get('filter').get('queryParamsValuesURI'));

        d3.json(url.href(), function(data) {
            var discourses = data['discourses'];
            var array = Object.keys(discourses).map(function (key) { return discourses[key].count; });
            var oldMin = Math.min(...array),
                oldMax = Math.max(...array);
            var sum = array.reduce(function(a, b) { return a + b; });
            var average = sum / array.length;
            var newMin = Math.floor((average - oldMin)),
                newMax = Math.floor((oldMax - average));

            var width = self.$().parent().width();
            var height = self.$().parent().height() - self.$().siblings().outerHeight(true);

            var bubble = d3.layout.pack()
                .sort(function comparator(a, b) { return a.value + b.value; })
                .size([width, height])
                .value(function(d){
                    return Math.floor((((d.value - oldMin) * (newMax - newMin)) / (oldMax - oldMin)) + newMin);
                })
                .padding(10);

            var element = d3.select('#' + self.get('elementId'));

            var bubbles = bubble.nodes(self.createNodes(discourses));

            var nodes = element
                .selectAll()
                .data(bubbles);

            nodes.enter().append("div")
                .attr("class", function(d) { return ( d.children ? "category": "item" ) + ( (self.get('filter').get('discourse') !== null && _.contains(self.get('filter').get('discourse'), d.id)) ? " selected" : "" ) ; });

            var item = element.selectAll(".item")
                .attr("data-id", function(d) { return d.id; })
                .style("left", function(d) { return ( d.x - d.r)  + "px"; })
                .style("top", function(d) { return ( d.y - d.r)  + "px"; })
                .style("width", function(d) { return (d.r * 2) + "px"; })
                .style("height", function(d) { return (d.r * 2) + "px"; })
                .style("background-color", function(d) { return d.fill; })
                .style("border-color", function(d) { return d.stroke; })
                .style("font-size", function(d) { return Math.floor((((d.value - oldMin) * (13 - 10)) / (oldMax - oldMin)) + 10) + 'px'; })
                .on('click', function(d) {
                    self.get('filter').setFilter('discourse', d.id);
                });

            item.append("span")
                .html(function(d) { return d.name + ' <span class="count">(' + d.count + ')</span>'; })
                .style("margin-left", function() { return ( Ember.$(this).width() > Ember.$(this).parent().width() ? - ( Ember.$(this).width() / 2 ) + ( Ember.$(this).parent().width() / 2 ) : 0 ) + 'px'; })
                .style("margin-top", function() { return Ember.$(this).parent().height() / 2 - Ember.$(this).height() / 2 + 'px'; });
        });

        this._super(...arguments);
    },

    createNodes: function(json) {
        var self = this;
        var children = [];

        Object.keys(json).forEach(function(key) {
            var discourse = json[key];
            var category_key = self.get('constants').DISCOURSE_CATEGORY_KEYS[key];
            var category_value = self.get('constants').DISCOURSE_CATEGORY_VALUES[category_key];

            children.push({
                'id': key,
                'name': discourse.label,
                'value': discourse.count,
                'count': discourse.count,
                'fill': category_value.fill,
                'stroke': category_value.stroke
            });
        });

        return { 'children': children };
    }

});
