@extends('sparql/sparqlClientResultBase')

@section('result-content')
<div class="result-bindings-heading panel-heading h3">Résultat de la requête
@if($results instanceof Illuminate\Pagination\LengthAwarePaginator)
 ({{ $results->firstItem() }}-{{ $results->lastItem() }} de {{ $results->total() }})
@else
 ({{$count}})
@endif
</div>
<div class="result-bindings-body panel-body">
    <div class="row">
        <div class="col-md-6">
        @if(count($namespaces)>0)
            <table class="result-bindings-namespaces table table-striped">
            <caption>Namespaces</caption>
            @foreach ($namespaces as $short => $uri)
                <tr><td class="result-bindings-namespaces-prefix-cell"><span class="result-bindings-namespaces-prefix">{{$short}}</span>:</td><td>{{$uri}}</td></tr>
            @endforeach
            </table>
        @endif
        </div>
        <div class="col-md-6">
            <form action="{{ route('sparql_query') }}" method="get" class="form-inline">
            <input type="hidden" name="query" value="{{ $query }}"/>
            <div class="form-group">
            <label for="format" class="n control-label">Download format</label>
            <select name="format" id="format" class="form-control">
                @foreach($downloadFormats as $t => $v)
                <option value="{{ $v }}">{{ $t }}</option>
                @endforeach
            </select>
            </div>
            <input id="submit-query-form" type="submit" class="btn btn-primary" value="download"/>
            <form>
        </div>
    </div>
    @if($results instanceof Illuminate\Pagination\LengthAwarePaginator)
    <div class="row">
        <div class="col-md-12">
            {{ $results->links() }}
        </div>
    </div>
    @endif
</div>
<div class="table-responsive">
    <table class='sparql-results table table-striped table-hover'>
    <thead>
    <tr>
        @foreach ($fields as $field)
        <th>{{ $fieldPrefix }}{{ $field }}</th>
        @endforeach
    </tr>
    </thead>
    <tbody>
        @foreach ($results as $row)
        <tr>
            @foreach ($fields as $field)
            <td>{!! $row[$field] !!}</td>
            @endforeach
        </tr>
        @endforeach
    </tbody>
    </table>
</div>
@if($results instanceof Illuminate\Pagination\LengthAwarePaginator)
<div class="panel-footer">
    {{ $results->links() }}
</div>
@endif

@endsection
