<?php

use Mockery as m;

use CorpusParole\Services\ViafResolverException;

/**
 *
 */
class ViafControllerTest extends TestCase {

    private $viafResolver;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->viafResolver = m::mock('CorpusParole\Services\ViafResolverInterface');
        $this->app->instance('CorpusParole\Services\ViafResolverInterface', $this->viafResolver);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testShow() {
        $this->viafResolver
            ->shouldReceive('getNames')
            ->with(['93752300', '56666014'])
            ->once()
            ->andReturn([
                '56666014' => 'Guylaine Brun-Trigaud',
                '93752300' => 'Sonia Branca-Rosoff'
            ]);
        $response = $this->get('/api/v1/viaf/93752300,56666014')->
            seeJsonEquals(['viafids' => [
                '56666014' => 'Guylaine Brun-Trigaud',
                '93752300' => 'Sonia Branca-Rosoff'
            ]]);
    }

    public function testShowOne() {
        $this->viafResolver
            ->shouldReceive('getNames')
            ->with(['93752300'])
            ->once()
            ->andReturn([
                '93752300' => 'Sonia Branca-Rosoff'
            ]);
        $response = $this->get('/api/v1/viaf/93752300')->
            seeJsonEquals(['viafids' => [
                '93752300' => 'Sonia Branca-Rosoff'
            ]]);
    }

    public function testShowUnknown() {
        $this->viafResolver
            ->shouldReceive('getNames')
            ->with(['12345'])
            ->once()
            ->andReturn([
                '12345' => null
            ]);
        $response = $this->get('/api/v1/viaf/12345')->
            seeJsonEquals(['viafids' => [
                '12345' => null
            ]]);
    }

    public function testShowMalformed() {
        $this->viafResolver
            ->shouldReceive('getNames')
            ->with(['abcdef','ghij'])
            ->once()
            ->andThrow('CorpusParole\Services\ViafResolverException', "ViafId not in correct format", 400);
        $response = $this->get('/api/v1/viaf/abcdef,ghij');

        $this->assertResponseStatus(400);
    }

}
