/*jshint node:true*/
module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var v1BnfRouter = express.Router();

  var bnfMappings = require('../fixtures/bnf');

  v1BnfRouter.get('/:id', function(req, res) {
    var idList = req.params.id.split(',');
    res.send({
      'bnfids': _.reduce(idList, function(r, id) {
        bnfid = "ark:/12148/" + id;
        r[bnfid] = (bnfid in bnfMappings)?bnfMappings[bnfid]:null;
        return r;
      }, {}),
    });
  });

  app.use('/api/v1/bnf', v1BnfRouter);
};
