<?php
namespace CorpusParole\Libraries\RdfModel;

use EasyRdf\Graph;

/**
 *
 */
class RdfModelDelta {

    public function __construct($uri) {
        $this->uri = $uri;
        $this->deletedGraph = new Graph($uri);
        $this->addedGraph = new Graph($uri);
        $this->deleteWhere = [];
    }

    private $deletedGraph;
    private $addedGraph;
    private $deleteWhere;

    public function getDeletedGraph() {
        return $this->deletedGraph;
    }

    public function getAddedGraph() {
        return $this->addedGraph;
    }

    public function getDeleteWhere() {
        return $this->deleteWhere;
    }

    public function addDeleteWhere(string $value) {
        array_push($this->deleteWhere, $value);
        return $this;
    }

    public function getUri() {
        return $this->uri;
    }

}
