import Ember from 'ember';

export default Ember.Component.extend({

    filter: Ember.inject.service(),

    elementId: "chrono-table",

    didInsertElement: function(){
        var self = this;

        if (this.get('filter').get('date') !== null){
            this.highlightQuery(this.get('filter').get('date'));
        }

        var isMouseDown = false,
        isHighlighted;

        Ember.$("#chrono-table li").mousedown(function () {
            isMouseDown = true;
            Ember.$(this).toggleClass("highlighted");
            isHighlighted = Ember.$(this).hasClass("highlighted");
            var dates = self.get('filter').get('date').toArray();
            var index = dates.indexOf(parseInt(Ember.$(this).attr('id')));
            if(index === -1) {
                dates.push(parseInt(Ember.$(this).attr('id')));
            } else {
                dates.splice(index, 1);
            }
            self.get('filter').set('date', dates);
            return false; // prevent text selection
        }).mouseover(function () {
            if (isMouseDown) {
                if(Ember.$(this).hasClass("highlighted") !== isHighlighted) {
                    Ember.$(this).toggleClass("highlighted", isHighlighted);
                    var dates = self.get('filter').get('date').toArray();
                    var index = dates.indexOf(parseInt(Ember.$(this).attr('id')));
                    if(index === -1) {
                        dates.push(parseInt(Ember.$(this).attr('id')));
                    } else {
                        dates.splice(index, 1);
                    }
                    self.get('filter').set('date', dates);
                }
            }
        }).bind("selectstart", function () {
            return false;
        });

        Ember.$(document).mouseup(function () {
            isMouseDown = false;
        });
    },

    highlightQuery: function(dates){
        dates.map(function(date){
            Ember.$("#" + date).toggleClass("highlighted", true);
        });
    }

});
