module.exports = function(app) {
  var express = require('express');
  var documentsRouter = express.Router();

  documentsRouter.get('/', function(req, res) {
    res.send({
      'documents': [{
            id: "crdo-ALA_170",
            uri: "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ALA_170",
            title: "Atlas Linguistique et ethnographique de l'Alsace - Enqu\u00eates linguistiques - Brumath: 03",
            publishers: ["Atlas linguistiques, cultures et parlers r\u00e9gionaux de France"],
            mediaArray: [
              {
                url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_170_22km.wav",
                format: "audio\/x-wav"},
              {
                url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_170.mp3",
                format: "audio\/mpeg"},
              {
                url: "http:\/\/purl.org\/poi\/crdo.vjf.cnrs.fr\/crdo-ALA_170",
                format: "audio\/x-wav" }
            ]
          },
          {
            id: "crdo-ALA_177",
            uri: "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ALA_177",
            title: "Atlas Linguistique et ethnographique de l'Alsace - Enqu\u00eates linguistiques - Cleebourg: 04",
            publishers: ["Atlas linguistiques, cultures et parlers r\u00e9gionaux de France"],
            mediaArray: [{
                url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_177_22km.wav",
                format: "audio\/x-wav"
            }, {
                url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_177.mp3",
                format: "audio\/mpeg"
            }, {
                url: "http:\/\/purl.org\/poi\/crdo.vjf.cnrs.fr\/crdo-ALA_177",
                format: "audio\/x-wav"
            }]
          }]
    });
  });

  documentsRouter.post('/', function(req, res) {
    res.status(201).end();
  });

  documentsRouter.get('/:id', function(req, res) {
    res.send({
      'document': {
        id: req.params.id,
        uri: "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ALA_170",
        title: "Atlas Linguistique et ethnographique de l'Alsace - Enqu\u00eates linguistiques - Brumath: 03",
        publishers: ["Atlas linguistiques, cultures et parlers r\u00e9gionaux de France"],
        mediaArray: [
          {
            url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_170_22km.wav",
            format: "audio\/x-wav"},
          {
            url: "http:\/\/cocoon.huma-num.fr\/data\/ala\/ALA_170.mp3",
            format: "audio\/mpeg"},
          {
            url: "http:\/\/purl.org\/poi\/crdo.vjf.cnrs.fr\/crdo-ALA_170",
            format: "audio\/x-wav" }
        ]
      }
    });
  });

  documentsRouter.put('/:id', function(req, res) {
    res.send({
      'document': {
        id: req.params.id
      }
    });
  });

  documentsRouter.delete('/:id', function(req, res) {
    res.status(204).end();
  });

  app.use('/api/documents', documentsRouter);
};
