module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var documentsRouter = express.Router();


  var documentList = require('../fixtures/documents');

  documentsRouter.get('/', function(req, res) {
    res.send({
      'documents': documentList,
    });
  });

  documentsRouter.post('/', function(req, res) {
    res.status(201).end();
  });

  documentsRouter.get('/:id', function(req, res) {

    var docRes = _.find(documentList, 'id', req.params.id);
    if(docRes) {
      res.send({'document': docRes});
    } else {
      res.status(404).send('Not found');
    }

  });

  documentsRouter.put('/:id', function(req, res) {
    res.send({
      'document': {
        id: req.params.id
      }
    });
  });

  documentsRouter.delete('/:id', function(req, res) {
    res.status(204).end();
  });

  app.use('/api/v1/documents', documentsRouter);
};
