<?php

use CorpusParole\Repositories\DocumentRepository;
use Mockery as m;
use Illuminate\Pagination\LengthAwarePaginator;
use CorpusParole\Models\Document;

/**
 *
 */
class DocumentListControllerTest extends TestCase {

    const GET_DOC = <<<EOT
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix sesame: <http://www.openrdf.org/schema/sesame#> .
    @prefix owl: <http://www.w3.org/2002/07/owl#> .
    @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
    @prefix fn: <http://www.w3.org/2005/xpath-functions#> .

    _:genid-25e7608caea646d5ba7b21eaf92c050f-genid1 a <http://www.europeana.eu/schemas/edm/Place> ;
    	owl:sameAs <http://sws.geonames.org/3469058/> ;
    	<http://www.w3.org/2004/02/skos/core#note> "BR"^^<http://purl.org/dc/terms/ISO3166> , "Brésil, Brasilia"@fr ;
    	<http://www.w3.org/2003/01/geo/wgs84_pos#lat> "-15.77972"^^xsd:float ;
    	<http://www.w3.org/2003/01/geo/wgs84_pos#long> "-47.92972"^^xsd:float .

    <http://corpusdelaparole.huma-num.fr/corpus/res/crdo-BOD092_SOUND> a <http://www.openarchives.org/ore/terms/Aggregation> ;
    	<http://www.europeana.eu/schemas/edm/aggregatedCHO> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-BOD092_SOUND> ;
    	<http://www.europeana.eu/schemas/edm/dataProvider> "Corpus de la Parole"@fr ;
    	<http://www.europeana.eu/schemas/edm/hasView> <http://cocoon.huma-num.fr/data/boutet/BOD092_low.mp4> , <http://cocoon.huma-num.fr/data/boutet/BOD092_low.ogg> ;
    	<http://www.europeana.eu/schemas/edm/isShownAt> <http://cocoon.huma-num.fr/exist/crdo/meta/crdo-BOD092_SOUND> ;
    	<http://www.europeana.eu/schemas/edm/isShownBy> <http://cocoon.huma-num.fr/data/archi/masters/350801.mp4> ;
    	<http://www.europeana.eu/schemas/edm/provider> "Corpus de la Parole"@fr ;
    	<http://www.europeana.eu/schemas/edm/rights> <http://creativecommons.org/licenses/by-nc-nd/4.0/> .

    <http://cocoon.huma-num.fr/data/archi/masters/350801.mp4> a <http://www.europeana.eu/schemas/edm/WebResource> ;
    	<http://purl.org/dc/elements/1.1/format> "video/mp4"^^<http://purl.org/dc/terms/IMT> ;
    	<http://purl.org/dc/terms/created> "2001-03"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/terms/extent> "PT00H01M54S" ;
    	<http://purl.org/dc/terms/issued> "2013-06-04T22:39:21+02:00"^^<http://purl.org/dc/terms/W3CDTF> .

    <http://cocoon.huma-num.fr/data/boutet/BOD092_low.mp4> a <http://www.europeana.eu/schemas/edm/WebResource> ;
    	<http://purl.org/dc/elements/1.1/format> "video/mp4"^^<http://purl.org/dc/terms/IMT> ;
    	<http://purl.org/dc/terms/created> "2001-03"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/terms/extent> "PT00H01M54S" ;
    	<http://purl.org/dc/terms/issued> "2013-06-04T22:39:21+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://www.europeana.eu/schemas/edm/isDerivativeOf> <http://cocoon.huma-num.fr/data/archi/masters/350801.mp4> .

    <http://cocoon.huma-num.fr/data/boutet/BOD092_low.ogg> a <http://www.europeana.eu/schemas/edm/WebResource> ;
    	<http://purl.org/dc/elements/1.1/format> "video/ogg"^^<http://purl.org/dc/terms/IMT> ;
    	<http://purl.org/dc/terms/created> "2001-03"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/terms/extent> "PT00H01M54S" ;
    	<http://purl.org/dc/terms/issued> "2013-06-04T22:39:21+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://www.europeana.eu/schemas/edm/isDerivativeOf> <http://cocoon.huma-num.fr/data/archi/masters/350801.mp4> .

    <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-BOD092_SOUND> a <http://www.europeana.eu/schemas/edm/ProvidedCHO> ;
    	<http://purl.org/dc/terms/created> "2001-03"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/terms/extent> "PT00H01M54S" ;
    	<http://purl.org/dc/terms/issued> "2013-06-04T22:39:21+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/elements/1.1/contributor> <http://viaf.org/viaf/202009521> , <http://viaf.org/viaf/74053259> , "Fiore, Sonia" , <http://viaf.org/viaf/207122465> , "Lacroix, Magdalena" , "Ivaldo" , "Lucia" ;
    	<http://purl.org/dc/elements/1.1/description> """Cette séquence fait partie du corpus vidéo de Langue des
    		Signes Emergentes utilisé lors de la thèse d'Ivani Fusellier-Souza : le locuteur Ivaldo
    		raconte que son oncle Geraldo est riche mais n'est pas radin, et qu'il y a très
    		longtemps lorsque les affaires marchaient pour son"""@fr ;
    	<http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/und> ;
    	<http://purl.org/dc/elements/1.1/rights> "Copyright (c) Cuxac, Christian" ;
    	<http://purl.org/dc/elements/1.1/subject> <http://ark.bnf.fr/ark:/12148/cb11946662b> , <http://ark.bnf.fr/ark:/12148/cb119339867> , <http://ark.bnf.fr/ark:/12148/cb11963612g> , "general_linguistics"^^<http://www.language-archives.org/OLAC/1.1/linguistic-field> , <http://ark.bnf.fr/ark:/12148/cb11965628b> , <http://lexvo.org/id/iso639-3/und> , <http://ark.bnf.fr/ark:/12148/cb119677899> , <http://ark.bnf.fr/ark:/12148/cb119511608> , <http://ark.bnf.fr/ark:/12148/cb16648129s> ;
    	<http://purl.org/dc/elements/1.1/title> "Corpus LS émergente, L'oncle Geraldo, raconté par Ivaldo"@fr ;
    	<http://purl.org/dc/elements/1.1/type> "dialogue"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> , "primary_text"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> , <http://purl.org/dc/dcmitype/MovingImage> ;
    	<http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
    	<http://purl.org/dc/terms/available> "2013-06-04"^^<http://purl.org/dc/terms/W3CDTF> ;
    	<http://purl.org/dc/terms/isPartOf> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE> ;
    	<http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-nd/2.5/> ;
    	<http://purl.org/dc/terms/spatial> _:genid-25e7608caea646d5ba7b21eaf92c050f-genid1 ;
    	<http://www.language-archives.org/OLAC/1.1/depositor> <http://viaf.org/viaf/202009521> , <http://viaf.org/viaf/74053259> ;
    	<http://www.language-archives.org/OLAC/1.1/interviewer> <http://viaf.org/viaf/207122465> ;
    	<http://www.language-archives.org/OLAC/1.1/speaker> "Ivaldo" , "Lucia" ;
    	<http://purl.org/dc/terms/tableOfContents> "00:00:00>00:00:45 Ivaldo raconte que son oncle Geraldo est riche. C'est un homme cultivé, qui a beaucoup d'argent. Il habite près de l'aéroport, où habite également l'amie de Lucia. La femme à Geraldo aussi est riche. 00:00:45>00:00:46 Lucia dit qu'il est riche, tant mieux pour lui. 00:00:46>00:01:55 Ivaldo raconte que son oncle était riche mais généreux. Il lui donne des billets d'avion pour voyager. Il lui donne également des vêtements. Ensuite, Ivaldo raconte qu'avant, son père était aisé et c'est l'oncle Geraldo qui ne l'était pas. Alors son père aidait l'oncle Geraldo car les affaires allaient bien. Mais par la suite, les affaires ont chutées et pour l'oncle Geraldo elles montaient."@fr ;
    	<http://www.language-archives.org/OLAC/1.1/compiler> <http://viaf.org/viaf/202009521> , <http://viaf.org/viaf/74053259> ;
    	<http://www.language-archives.org/OLAC/1.1/data_inputter> <http://viaf.org/viaf/202009521> , "Fiore, Sonia" , "Lacroix, Magdalena" ;
    	<http://purl.org/dc/terms/alternative> "Séquence 13, L'oncle Geraldo, raconté par Ivaldo"@fr ;
    	<http://www.language-archives.org/OLAC/1.1/author> <http://viaf.org/viaf/207122465> ;
    	<http://www.language-archives.org/OLAC/1.1/translator> <http://viaf.org/viaf/207122465> .
EOT;

#""" comment for syntax highliting

    private $documentRepository;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->documentRepository = m::mock('CorpusParole\Repositories\DocumentRepository');
        $this->app->instance('CorpusParole\Repositories\DocumentRepository', $this->documentRepository);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {
        $this->documentRepository
            ->shouldReceive('paginateAll')
            ->once()
            ->andReturn(
                new LengthAwarePaginator([], 0, 10, 1, [
                    'path' => '',
                    'pageName' => 'page',
                ]));

        $response = $this->call('GET', '/bo/docs');

        $this->assertResponseOk($response);
        $this->assertViewHas('docs');
    }

    public function testShow() {
        $res_doc = new EasyRdf\Graph('http://corpusdelaparole.huma-num.fr/corpus/res/crdo-BOD092_SOUND',DocumentListControllerTest::GET_DOC);
        $this->documentRepository
            ->shouldReceive('get')
            ->once()
            ->andReturn(new Document('http://corpusdelaparole.huma-num.fr/corpus/res/crdo-BOD092_SOUND', $res_doc));

        $response = $this->visit('/bo/docs/crdo-BOD092_SOUND');

    }
}
