<?php
namespace CorpusParole\Libraries;

class CocoonUtils {

    const OLAC_ROLES = [
        'http://www.language-archives.org/OLAC/1.1/annotator',
        'http://www.language-archives.org/OLAC/1.1/author',
        'http://www.language-archives.org/OLAC/1.1/compiler',
        'http://www.language-archives.org/OLAC/1.1/consultant',
        'http://www.language-archives.org/OLAC/1.1/data_inputter',
        'http://www.language-archives.org/OLAC/1.1/depositor',
        'http://www.language-archives.org/OLAC/1.1/developer',
        'http://www.language-archives.org/OLAC/1.1/editor',
        'http://www.language-archives.org/OLAC/1.1/illustrator',
        'http://www.language-archives.org/OLAC/1.1/interpreter',
        'http://www.language-archives.org/OLAC/1.1/interviewer',
        'http://www.language-archives.org/OLAC/1.1/participant',
        'http://www.language-archives.org/OLAC/1.1/performer',
        'http://www.language-archives.org/OLAC/1.1/photographer',
        'http://www.language-archives.org/OLAC/1.1/recorder',
        'http://www.language-archives.org/OLAC/1.1/researcher',
        'http://www.language-archives.org/OLAC/1.1/research_participant',
        'http://www.language-archives.org/OLAC/1.1/responder',
        'http://www.language-archives.org/OLAC/1.1/signer',
        'http://www.language-archives.org/OLAC/1.1/singer',
        'http://www.language-archives.org/OLAC/1.1/speaker',
        'http://www.language-archives.org/OLAC/1.1/sponsor',
        'http://www.language-archives.org/OLAC/1.1/transcriber',
        'http://www.language-archives.org/OLAC/1.1/translator',
    ];

    /**
     * Extract id form cocoon url.
     *
     * @return string
     */
    public static function getIdFromUri($uri) {
        return substr($uri, strlen(config('corpusparole.cocoon_doc_id_base_uri')));
    }

    /**
     * Extract id form corpus url.
     *
     * @return string
     */
    public static function getIdFromCorpusUri($uri) {
        return substr($uri, strlen(config('corpusparole.corpus_doc_id_base_uri')));
    }

    /**
     * Create a Corpus resource id (purl url)
     *
     * @return string
     */
    public static function getCorpusUriFromId($id) {
        return rtrim(config('corpusparole.corpus_doc_id_base_uri'),'/')."/$id";
    }

    public static function getCocoonPubUrl($id) {
        return rtrim(config('corpusparole.cocoon_doc_pub_base_uri'), '/')."/$id";
    }

}
