<?php

$sesameBaseUrl = rtrim(env('CORPUSPAROLE_SESAME_BASE_URL'),'/').'/';
$baseUrl = parse_url(env('APP_URL','http://localhost'), PHP_URL_PATH);
$baseUrl = ($baseUrl && strlen($baseUrl)>0)?$baseUrl:"/";

return [
    'pagination_page_param' => 'page',

    'documents_per_page' => 15,

    'elasticsearch_index' => env('ELASTICSEARCH_INDEX'),

    'sesame_base_url' => $sesameBaseUrl,
    'sesame_repository' => env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_repository_raw' => env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'max_load_retry' => env('CORPUSPAROLE_MAX_LOAD_RETRY', 5),
    'sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY'),
    'sesame_update_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY').'/statements',
    'sesame_query_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW'),
    'sesame_update_url_raw' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_REPOSITORY_RAW').'/statements',
    'corpus_ontology_url' => env('CORPUSPAROLE_ONTOLOGY_URL', 'http://corpusdelaparole.culture.fr/ontology/'),

    'cocoon_rdf_base_uri' => env('CORPUSPAROLE_COCOON_RDF_BASE_URI'),
    'cocoon_oaipmh_url' => env('CORPUSPAROLE_COCOON_OAIPMH_URL'),
    'cocoon_doc_id_base_uri' => 'http://purl.org/poi/crdo.vjf.cnrs.fr/',
    'cocoon_doc_pub_base_uri' => 'http://corpusdelaparole.huma-num.fr/corpus-app#/detail/',
    'cocoon_doc_id_base' => 'oai:crdo.vjf.cnrs.fr:',

    'corpus_id_scheme' => env('HANDLE_PREFIX').'/',
    'corpus_id_prefix' => env('HANDLE_PREFIX').'/crdo-',

    'corpus_doc_id_base_uri_prefix' => 'https://hdl.handle.net/',
    'corpus_doc_id_base_uri' => 'https://hdl.handle.net/'.env('HANDLE_PREFIX').'/',
    'corpus_doc_default_cc_rights' => 'http://creativecommons.org/licenses/by/4.0/',

    'edm_provider' => 'Corpus de la Parole',

    'easyrdf_http_client_timeout' => env('EASYRDF_HTTP_CLIENT_TIMEOUT', 1000),

    'corpus_discourse_type' => [
        "http://ark.bnf.fr/ark:/12148/cb12083158d" => "argumentation",
        "http://ark.bnf.fr/ark:/12148/cb119783362" => "bavardage",
        "http://ark.bnf.fr/ark:/12148/cb13319048g" => "chansons",
        "http://ark.bnf.fr/ark:/12148/cb11931724n" => "congrès et conférences",
        "http://ark.bnf.fr/ark:/12148/cb11936159v" => "contes",
        "http://ark.bnf.fr/ark:/12148/cb119317924" => "conversation",
        "http://ark.bnf.fr/ark:/12148/cb12481481z" => "dialogue",
        "http://ark.bnf.fr/ark:/12148/cb11948542x" => "discours",
        "http://ark.bnf.fr/ark:/12148/cb119341539" => "discussion",
        "http://ark.bnf.fr/ark:/12148/cb120502737" => "enquêtes linguistiques",
        "http://ark.bnf.fr/ark:/12148/cb11932135w" => "entretiens",
        "http://ark.bnf.fr/ark:/12148/cb11953414d" => "fables",
        "http://ark.bnf.fr/ark:/12148/cb11955657q" => "lecture à haute voix",
        "http://ark.bnf.fr/ark:/12148/cb11957378b" => "musique instrumentale",
        "http://ark.bnf.fr/ark:/12148/cb11937212q" => "narration",
        "http://ark.bnf.fr/ark:/12148/cb11946100d" => "paradigme (épistémologie)",
        "http://ark.bnf.fr/ark:/12148/cb119829234" => "questionnaires",
        "http://ark.bnf.fr/ark:/12148/cb119834877" => "récitation",
        "http://ark.bnf.fr/ark:/12148/cb11976851v" => "récits personnels",
        "http://ark.bnf.fr/ark:/12148/cb11949715t" => "réunions"
    ],

    'olac_base_url' => 'http://www.language-archives.org/OLAC',

    'olac_discourse_type' => [
        'uri' => 'http://www.language-archives.org/OLAC/1.1/discourse-type',
        'values' => [
            [
                'code' => 'dialogue',
                'name' => 'Dialogue',
            ],

            [
                'code' => 'drama',
                'name' => 'Drama',
            ],

            [
                'code' => 'formulaic',
                'name' => 'Formulaic Discourse',
            ],

            [
                'code' => 'ludic',
                'name' => 'Ludic Discourse',
            ],
            [
                'code' => 'oratory',
                'name' => 'Oratory',
            ],

            [
                'code' => 'narrative',
                'name' => 'Narrative Discourse',
            ],

            [
                'code' => 'procedural',
                'name' => 'Procedural Discourse',
            ],

            [
                'code' => 'report',
                'name' => 'Report',
            ],

            [
                'code' => 'singing',
                'name' => 'Singing',
            ],

            [
                'code' => 'unintelligible_speech',
                'name' => 'Unintelligible Speech',
            ]
        ]
    ],

    'viaf_base_url' => 'http://viaf.org/viaf/',
    'viaf_cache_expiration' => 60*24*30,
    'viaf_max_ids' => 500,

    'theme_default_limit' => 40,

    'lexvo_base_url' => 'http://lexvo.org/id/iso639-3/',
    'lexvo_url_regexp' => '/http[s]?\:\/\/lexvo\.org\/id\/iso639\-3\/([[:alpha:]]{3})\/?/',
    'lexvo_cache_expiration' => 60*24*30,
    'lexvo_max_ids' => 50,
    'lexvo_sesame_query_url' => $sesameBaseUrl.'repositories/'.env('CORPUSPAROLE_SESAME_LEXVO_REPOSITORY'),

    'bnf_base_url' => 'http://data.bnf.fr/',
    'bnf_ark_base_url' => 'http://ark.bnf.fr/',
    'bnf_ark_url_regexp' => '/http[s]?\:\/\/(?:data|ark)\.bnf\.fr\/(ark\:\/12148\/[[:alnum:]]+)\/?/',
    'bnf_ark_id_base' => "ark:/12148/",
    'bnf_cache_expiration' => 60*24*30,
    'bnf_max_ids' => 5,
    'bnf_query_url' => 'http://data.bnf.fr/sparql',
    'bnf_completion_url' => 'http://data.bnf.fr/search-letter/',

    'dbpedia_url_regexp' => '/^https?\:\/\/(([[:alpha:]]+\.)?dbpedia\.org)\/(resource|page)\/([^\/]+)\/?$/',

    'geonames_base_url' => 'http://sws.geonames.org/',
    'geonames_url_regexp' => '/http[s]?\:\/\/(?:sws|www)\.geonames\.org\/(\d+)\/?/',
    'geonames_cache_expiration' => 60*24*30,
    'geonames_max_ids' => 500,
    'geonames_hierarchy_webservice_url' => 'http://api.geonames.org/hierarchyJSON',
    'geonames_username' => env('GEONAMES_USERNAME'),
    'geonames_earth_geonamesid' => '6295630',

    'bo_client_environment' => [
        "modulePrefix" => "bo-client",
        "podModulePrefix" => "bo-client/pods",
        "environment" => "production",
        "baseURL" => $baseUrl,
        "locationType" => "hash",
        "i18n" => ["defaultLocale" => "fr"],
        "EmberENV" => ["FEATURES"=>(object)[]], # to force json serialisation as object
        "APP" => [
            "bo-doc-viaf-autocomplete" => [
                "viafQueryUrl" => "http://viaf.org/viaf/AutoSuggest?query=",
                "viafBaseUrl" => "http://viaf.org/viaf/"
            ],
            'bo-doc-bnf-autocomplete' => [
                "bnfQueryUrl" => "${baseUrl}proxy/bnf/?term=",
                "bnfBaseUrl" => "http://data.bnf.fr/",
                "bnfSparqlUrl" => "${baseUrl}proxy/bnf-sparql"
            ],
            "LOG_RESOLVER" => true,
            "LOG_ACTIVE_GENERATION" => true,
            "LOG_TRANSITIONS" => true,
            "LOG_TRANSITIONS_INTERNAL" => true,
            "LOG_VIEW_LOOKUPS" => true,
            "name" => "bo-client",
            "version" => "0.0.0 "
        ],
        "contentSecurityPolicy" => [
            "default-src" => "'none'",
            "script-src" => "'self'",
            "font-src" => "'self'",
            "connect-src" => "'self' *",
            "img-src" => "'self'",
            "style-src" => "'self' *",
            "media-src" => "'self'"
        ],
        "contentSecurityPolicyHeader" => "Content-Security-Policy-Report-Only",
        "exportApplicationGlobal" => true
    ],

    'handle_host'         => env('HANDLE_HOST'),
    'handle_port'         => env('HANDLE_PORT', 8000),
    'handle_admin_id'     => env('HANDLE_ADMIN_ID'),
    'handle_prefix'       => env('HANDLE_PREFIX'),
    'handle_cert_or_pkey' => env('HANDLE_CERT_OR_PKEY'),
    'handle_password'     => env('HANDLE_PASSWORD'),

    'transcript_default_creator' => 'Corpus de la Parole',
    'transcrit_decoder_mapping' => [
        "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_archive" => 'CorpusParole\Libraries\Transcript\LacitoTranscriptConverter',
        "http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber" => 'CorpusParole\Libraries\Transcript\TranscriberTranscriptConverter'
    ],

    "language_corpus_node_prefix" => 'corpus-',
    "language_corpus_node_global" => 'corpus-global',

    "languages_treemap" => [
        'id' => 'corpus-global',
        'name' => 'Global',
        'children' => [ [
            'id' => 'http://lexvo.org/id/iso639-3/fra',
            'name' => 'Français'
          ], [
            'id' => 'http://lexvo.org/id/iso639-3/gsw',
            'name' => 'Alsacien'
          ], [
            'id' => 'http://lexvo.org/id/iso639-3/bre',
            'name' => 'Breton'
          ], [
            'id' => 'http://lexvo.org/id/iso639-3/oci',
            'name' => 'Occitan',
          ], [
            'id' => 'http://lexvo.org/id/iso639-3/lad',
            'name' => 'Judéo-espagnol'
          ], [
            'id' => 'http://lexvo.org/id/iso639-3/und',
            'name' => 'Indéterminée',
          ], [
            'id' => 'corpus-regionals',
            'name' => 'Langues régionales',
            'children' => [ [
                    'id' => 'corpus-oil',
                    'name' => 'Langues d\'oïl',
                    'values' => [ 'http://lexvo.org/id/iso639-3/pcd' ]
                  ], [
                    'id' => 'http://lexvo.org/id/iso639-3/frp',
                    'name' => 'Francoprovençal'
                  ], [
                    'id' => 'http://lexvo.org/id/iso639-3/cos',
                    'name' => 'Corse'
                  ], [
                    'id' => 'corpus-creoles',
                    'name' => 'Les Créoles',
                    'children' => [ [
                        'id' => 'http://lexvo.org/id/iso639-3/rcf',
                        'name' => 'Créole de la Réunion'
                      ], [
                        'id' => 'http://lexvo.org/id/iso639-3/gcf',
                        'name' => 'Créole de la Guadeloupe'
                      ]
                    ]
                ]
            ]
          ], [
            'id' => 'corpus-non-territorials',
            'name' => 'Langues non territoriales',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/fsl',
                'name' => 'Langue des signes française (LSF)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/kab',
                'name' => 'Berbère'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/ell',
                'name' => 'Grec moderne'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/spa',
                'name' => 'Espagnol'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/eng',
                'name' => 'Anglais'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/ita',
                'name' => 'Italien'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/deu',
                'name' => 'Allemand'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/tur',
                'name' => 'Turque'
              ]
            ]
          ], [
            'id' => 'corpus-guyane',
            'name' => 'Guyane',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/gcf',
                'name' => 'Ndyuka-Trio Pidgin (njt)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/plu',
                'name' => 'Palikúr (plu)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/gcr',
                'name' => 'Guianese Creole French (gcr)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/gcr',
                'name' => 'Guianese Creole French (gcr)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/srn',
                'name' => 'Sranan Tongo (srn)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/car',
                'name' => 'kali\'na (car)'
              ]
            ]
          ], [
            'id' => 'corpus-mayotte',
            'name' => 'Mayotte',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/swb',
                'name' => 'Maore Comorian (swb)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/lsy',
                'name' => 'Mauritian Sign Language (lsy)'
              ]
            ]
          ], [
            'id' => 'corpus-polynesia',
            'name' => 'Polynésie française',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/uve',
                'name' => 'West Uvean (uve)'
              ]
            ]
          ], [
            'id' => 'corpus-wallis-futuna',
            'name' => 'Wallis et Futuna',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/fud',
                'name' => 'LanEast Futuna (fud)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/wls',
                'name' => 'Wallisian (wls)'
              ]
            ]
          ], [
            'id' => 'corpus-new-caledonia',
            'name' => 'Nouvelle-Calédonie',
            'children' => [ [
                'id' => 'http://lexvo.org/id/iso639-3/wls',
                'name' => 'Wallisian (wls)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/ane',
                'name' => 'Xârâcùù (ane)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/cam',
                'name' => 'Cemuhî (cam)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/axx',
                'name' => 'Xaragure (axx)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/iai',
                'name' => 'Iaai (iai)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/nee',
                'name' => 'Nêlêmwa-Nixumwak (nee)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/dhv',
                'name' => 'Dehu (dhv)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/nen',
                'name' => 'Nengone (nen)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/aji',
                'name' => 'Ajië (aji)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/kdk',
                'name' => 'Numee (kdk)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/nem',
                'name' => 'Nemi'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/nua',
                'name' => 'Yuaga (nua)'
              ], [
                'id' => 'http://lexvo.org/id/iso639-3/bwa',
                'name' => 'Bwatoo (bwa)'
              ]
            ]
          ]
        ]
    ]

];
