/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.MultiHostConnectionProxy;
import com.mysql.jdbc.MultiHostMySQLConnection;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.ReplicationConnection;
import com.mysql.jdbc.ReplicationConnectionProxy;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ReplicationMySQLConnection
extends MultiHostMySQLConnection
implements ReplicationConnection {
    public ReplicationMySQLConnection(MultiHostConnectionProxy proxy) {
        super(proxy);
    }

    protected ReplicationConnectionProxy getThisAsProxy() {
        return (ReplicationConnectionProxy)super.getThisAsProxy();
    }

    public synchronized Connection getCurrentConnection() {
        return this.getThisAsProxy().getCurrentConnection();
    }

    public long getConnectionGroupId() {
        return this.getThisAsProxy().getConnectionGroupId();
    }

    public synchronized Connection getMasterConnection() {
        return this.getThisAsProxy().getMasterConnection();
    }

    public void promoteSlaveToMaster(String host) throws SQLException {
        this.getThisAsProxy().promoteSlaveToMaster(host);
    }

    public void removeMasterHost(String host) throws SQLException {
        this.getThisAsProxy().removeMasterHost(host);
    }

    public void removeMasterHost(String host, boolean waitUntilNotInUse) throws SQLException {
        this.getThisAsProxy().removeMasterHost(host, waitUntilNotInUse);
    }

    public boolean isHostMaster(String host) {
        return this.getThisAsProxy().isHostMaster(host);
    }

    public synchronized Connection getSlavesConnection() {
        return this.getThisAsProxy().getSlavesConnection();
    }

    public void addSlaveHost(String host) throws SQLException {
        this.getThisAsProxy().addSlaveHost(host);
    }

    public void removeSlave(String host) throws SQLException {
        this.getThisAsProxy().removeSlave(host);
    }

    public void removeSlave(String host, boolean closeGently) throws SQLException {
        this.getThisAsProxy().removeSlave(host, closeGently);
    }

    public boolean isHostSlave(String host) {
        return this.getThisAsProxy().isHostSlave(host);
    }

    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        this.getThisAsProxy().setReadOnly(readOnlyFlag);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getThisAsProxy().isReadOnly();
    }

    public synchronized void ping() throws SQLException {
        block5: {
            block4: {
                try {
                    this.getThisAsProxy().masterConnection.ping();
                }
                catch (SQLException e) {
                    if (!this.isMasterConnection()) break block4;
                    throw e;
                }
            }
            try {
                this.getThisAsProxy().slavesConnection.ping();
            }
            catch (SQLException e) {
                if (this.isMasterConnection()) break block5;
                throw e;
            }
        }
    }

    public synchronized void changeUser(String userName, String newPassword) throws SQLException {
        this.getThisAsProxy().masterConnection.changeUser(userName, newPassword);
        this.getThisAsProxy().slavesConnection.changeUser(userName, newPassword);
    }

    public synchronized void setStatementComment(String comment) {
        this.getThisAsProxy().masterConnection.setStatementComment(comment);
        this.getThisAsProxy().slavesConnection.setStatementComment(comment);
    }

    public boolean hasSameProperties(Connection c) {
        return this.getThisAsProxy().masterConnection.hasSameProperties(c) && this.getThisAsProxy().slavesConnection.hasSameProperties(c);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getThisAsProxy().masterConnection.getProperties());
        props.putAll((Map<?, ?>)this.getThisAsProxy().slavesConnection.getProperties());
        return props;
    }

    public void abort(Executor executor) throws SQLException {
        this.getThisAsProxy().doAbort(executor);
    }

    public void abortInternal() throws SQLException {
        this.getThisAsProxy().doAbortInternal();
    }

    public boolean getAllowMasterDownConnections() {
        return this.getThisAsProxy().allowMasterDownConnections;
    }

    public void setAllowMasterDownConnections(boolean connectIfMasterDown) {
        this.getThisAsProxy().allowMasterDownConnections = connectIfMasterDown;
    }

    public boolean getReplicationEnableJMX() {
        return this.getThisAsProxy().enableJMX;
    }

    public void setReplicationEnableJMX(boolean replicationEnableJMX) {
        this.getThisAsProxy().enableJMX = replicationEnableJMX;
    }

    public void setProxy(MySQLConnection proxy) {
        this.getThisAsProxy().setProxy(proxy);
    }
}

