class sysconfig::sys_upgrade {
    package { 'epel':
        name => 'epel-release',
        ensure => present,
    }->
    yumrepo { 'remi':
        descr      => 'Les RPM de remi pour Enterpise Linux $releasever - $basearch',
        mirrorlist => 'http://rpms.famillecollet.com/enterprise/$releasever/remi/mirror',
        gpgcheck   => 1,
        gpgkey     => 'http://rpms.remirepo.net/RPM-GPG-KEY-remi',
        enabled    => 1,
        priority   => 1,
    }->
    exec { "yum-update":
        command => "yum clean all; yum -q -y update",
        timeout => 1800,
        onlyif => "/usr/bin/test `stat --format=%Y /var/lib/yum/rpmdb-indexes` -le $(( `date +%s` - 86400 )) -o ! -e /var/lib/puppet/state/first_run ",
        #onlyif => "/usr/bin/test `stat --format=%Y /var/lib/yum/rpmdb-indexes` -le $(( `date +%s` ))",
        path => [ '/bin', '/usr/bin', '/uhttp://rpms.remirepo.net/RPM-GPG-KEY-remisr/local/bin' ]
    }
}
