class sysconfig::mariadb (
    $db_name      = hiera('sysconfig::params::db_name',      sysconfig::params::db_name),
    $db_drpl_name = hiera('sysconfig::params::db_drpl_name', $sysconfig::params::db_drpl_name),
    $db_user      = hiera('sysconfig::params::db_user',      $sysconfig::params::db_user),
    $db_pw        = hiera('sysconfig::params::db_pw',        $sysconfig::params::db_pw),
    $db_host      = hiera('sysconfig::params::db_host',      $sysconfig::params::db_host),
    $db_port      = hiera('sysconfig::params::db_port',      $sysconfig::params::db_port),
    $hdl_db_name  = hiera('sysconfig::params::hdl_db_name', $sysconfig::params::hdl_db_name),
) inherits sysconfig::params {

    $mariadb_packages = [
        'mariadb-server'
    ]

    package { $mariadb_packages:
        ensure => present,
        notify  => Service["mariadb"]
    }

    service { "mariadb":
        ensure => running,
        enable => true
    }

    augeas { "mariadb_server_cnf/max_allowed_packet":
        lens    => "MySQL.lns",
        incl    => "/etc/my.cnf.d/server.cnf",
        changes => "set target[.='mysqld']/max_allowed_packet 16M",
        notify  => Service["mariadb"],
        require => Package["mariadb-server"]
    }

    augeas { "mariadb_server_cnf/collation-server":
        lens    => "MySQL.lns",
        incl    => "/etc/my.cnf.d/server.cnf",
        changes => "set target[.='mysqld']/collation-server utf8mb4_general_ci",
        notify  => Service["mariadb"],
        require => Package["mariadb-server"]
    }

    augeas { "mariadb_server_cnf/character-set-server":
        lens    => "MySQL.lns",
        incl    => "/etc/my.cnf.d/server.cnf",
        changes => "set target[.='mysqld']/character-set-server utf8mb4",
        notify  => Service["mariadb"],
        require => Package["mariadb-server"]
    }

    augeas { "mariadb_client_cnf/default-character-set":
        lens    => "MySQL.lns",
        incl    => "/etc/my.cnf.d/client.cnf",
        changes => "set target[.='client']/default-character-set utf8mb4",
        notify  => Service["mariadb"],
        require => Package["mariadb-server"]
    }

    augeas { "mariadb_mysql-client_cnf/default-character-set":
        lens    => "MySQL.lns",
        incl    => "/etc/my.cnf.d/mysql-clients.cnf",
        changes => "set target[.='mysql']/default-character-set utf8mb4",
        notify  => Service["mariadb"],
        require => Package["mariadb-server"]
    }

    mysql::db { "drupal_db":
        dbname => $db_drpl_name,
        user => $db_user,
        password => $db_pw,
        host => $db_host,
        charset => 'utf8mb4',
        collate => 'utf8mb4_general_ci',
        require => Service["mariadb"],
    }
    mysql::db { "corpus_db":
        dbname => $db_name,
        user => $db_user,
        password => $db_pw,
        host => $db_host,
        charset => 'utf8mb4',
        collate => 'utf8mb4_general_ci',
        require => Service["mariadb"],
    }


    #TODO: create user

    #TODO: create databases

    # max_allowed_packet : > 16M ->
    # [mysqld]
    # collation-server     = utf8mb4_general_ci
    # character-set-server = utf8mb4


}
