import Ember from 'ember';
import store from 'corpus-common-addon/utils/store';
import * as constants from 'corpus-common-addon/utils/constants'

export default Ember.Service.extend({
  env: function() {
    return Ember.getOwner(this).resolveRegistration('config:environment')
  },
  _getStoreKey: function(id) {
    return 'viaf:'+id;
  },
  getName: function(id) {
    var viafId = id;
    if(id.startsWith(constants.VIAF_BASE_URL)) {
      viafId = id.slice(constants.VIAF_BASE_URL.length);
    }
    var storeKey = this._getStoreKey(id);
    var namePromise = null;

    var name = store.get(storeKey);
    if(!name) {
      //TODO: handle error !!!
      namePromise = this.queryName(viafId)
        .then( function(response) {
            return store.set(storeKey, response);
        });
    }
    else {
      namePromise = new Ember.RSVP.Promise(function(resolve/*, reject*/) {
        resolve(name);
      });
    }
    return namePromise;
  },
  // make the query for the name.
  // return a Promise
  queryName: function(id) {
    return new Ember.RSVP.Promise(function(resolve, reject) {
      Ember.$.ajax({
        url: this.env().baseURL.replace(/\/$/,"") + "/api/v1/viaf/"+id,
        success: function(viafDoc) {
          var names = viafDoc.viafids;
          resolve((id in names)?names[id]:null);
        },
        error: function(req, status, error) {
          reject(status + ":" + error);
        }
      });
    }.bind(this));
  }
});
