import Ember from 'ember';

const { getOwner } = Ember;

export default Ember.Component.extend({

    elementId: "chrono-table",

    didInsertElement: function(){
        var self = this;

        if (getOwner(self).lookup('controller:application').date !== null){
            this.highlightQuery(getOwner(self).lookup('controller:application').date);
        }

        var isMouseDown = false,
        isHighlighted;

        Ember.$("#chrono-table li").mousedown(function () {
            isMouseDown = true;
            Ember.$(this).toggleClass("highlighted");
            isHighlighted = Ember.$(this).hasClass("highlighted");
            self.sendUpdate();
            return false; // prevent text selection
        }).mouseover(function () {
            if (isMouseDown) {
                Ember.$(this).toggleClass("highlighted", isHighlighted);
                self.sendUpdate();
            }
        }).bind("selectstart", function () {
            return false;
        });

        Ember.$(document).mouseup(function () {
            isMouseDown = false;
        });
    },

    sendUpdate: function(){
        var dateQuery = [];
        Ember.$('.highlighted').map(function(index, elt) {
            dateQuery.push(parseInt(Ember.$(elt).parent().attr('id')) + parseInt(Ember.$(elt).html()));
        });
        this.sendAction('action', dateQuery);
    },

    highlightQuery: function(list){
        list.map(function(elt){
            var year = Math.floor(parseInt(elt)/10)*10;
            Ember.$("#"+year+" ."+(parseInt(elt)-year)).toggleClass("highlighted", true);
        });
    }

});
