import Ember from 'ember';
import AmCharts from 'ammaps';

export default Ember.Component.extend({
  // storage: Ember.inject.service(),
  didInsertElement: function(){
    var _this = this;

    var franceDataProvider = {
        mapVar: AmCharts.maps.france2016Low,
        getAreasFromMap:true,

        areas: this.initArea(AmCharts.maps.france2016Low)
    };

    var worldDataProvider = {
        map: "worldLow",
        getAreasFromMap: true,
        images: [{
            id: "backButton",
            label: "Back to continents map",
            rollOverColor: "#CC0000",
            labelRollOverColor: "#CC0000",
            useTargetsZoomValues: true,
            left: 30,
            bottom: 30,
            labelFontSize: 15,
            selectable: true
        }],
        areas: this.initArea(AmCharts.maps.worldLow, franceDataProvider)
    };


    var continentsDataProvider = {
        map: "continentsLow",

        areas: [{
            id: "africa",
            linkToObject: worldDataProvider,
            color: "#373737",
            passZoomValuesToTarget: true
        }, {
            id: "asia",
            linkToObject: worldDataProvider,
            color: "#515151",
            selectable: false,
            passZoomValuesToTarget: true
        }, {
            id: "australia",
            linkToObject: worldDataProvider,
            color: "#6c6c6c",
            selectable: false,
            passZoomValuesToTarget: true
        }, {
            id: "europe",
            linkToObject: worldDataProvider,
            color: "#888888",
            passZoomValuesToTarget: true
        }, {
            id: "north_america",
            linkToObject: worldDataProvider,
            color: "#a2a2a2",
            passZoomValuesToTarget: true
        }, {
            id: "south_america",
            linkToObject: worldDataProvider,
            color: "#f1f1f1",
            selectable: false,
            passZoomValuesToTarget: true
        }]

    };


    var map = AmCharts.makeChart("mapdiv", {
        type: "map",


        areasSettings: {
            autoZoom: true,
            rollOverOutlineColor: "#000000",
            selectedOutlineColor: "#CC0000",
            selectedColor: "green",
            color: "#fff"
        },

        dataProvider: continentsDataProvider,

        listeners: [{event:"clickMapObject", method:handleMapObjectClick}]

    });

    function handleGoHome() {
        map.dataProvider = continentsDataProvider;
        map.validateNow();
    }
    function handleMapObjectClick (event) {
      console.log("bbox: ", event.mapObject.displayObject.node.getBBox());
        if (event.mapObject.id === "backButton") {
            handleGoHome();
        }
        _this.sendAction('action', event.mapObject.title);
    }

    // monitor when home icon was clicked and also go to continents map
    map.addListener("homeButtonClicked", handleGoHome);
  },
  initArea: function(area, dataProvider){
    var _this = this;

    var areaList = [];
    var count = {};
    area.svg.g.path.map(function(elt){
      var length = _this.get("documents").filterBy("spatial", elt.title).toArray().length;
      if (length > 0){
        count[elt.id]= length;
      }
    });
    area.svg.g.path.map(function(elt){

      areaList.push({
        id: elt.id,
        linkToObject: (elt.id === "FR" ? dataProvider : ""),
        color: ((typeof(count[elt.id]) === "undefined") ? "#fff" : "#2D7073"),
        autoZoom: (elt.id === "FR" ? true : false),
        selectable: true,
        passZoomValuesToTarget: false
      });
    });
    return areaList;
  }
});
