/* eslint-env node */
/* eslint global-require: 0, no-magic-numbers: 0 */

module.exports = function(app) {
  const express = require('express');
  const _ = require('lodash');

  const documentsRouter = express.Router();


  const documentList = require('../fixtures/documents');

  documentsRouter.get('/', function(req, res) {
    res.send({documents: _.map(documentList, function(doc) {
      return {
        id: doc.id,
        uri: doc.uri,
        title: doc.title,
        language: doc.language,
        modified: doc.modified,
        issued: doc.issued
      };
    })});
  });

  documentsRouter.post('/', function(req, res) {
    res.status(201).end();
  });

  documentsRouter.get('/:id', function(req, res) {

    const docRes = _.find(documentList, 'id', req.params.id);

    if (docRes) {
      res.send({document: docRes});
    } else {
      res.status(404).send('Not found');
    }

  });

  documentsRouter.put('/:id', function(req, res) {
    res.send({
      document: {
        id: req.params.id
      }
    });
  });

  documentsRouter.delete('/:id', function(req, res) {
    res.status(204).end();
  });

  app.use('/api/v1/documents', documentsRouter);
};
