/* jshint node:true */
/* eslint-env node */
/* eslint global-require: 0 */

module.exports = function(app) {
  const express = require('express');
  const _ = require('lodash');

  const v1BnfRouter = express.Router();

  const bnfMappings = require('../fixtures/bnf');

  v1BnfRouter.get('/:id', function(req, res) {
    const idList = req.params.id.split(',');

    res.send({
      'bnfids': _.reduce(idList, function(r, id) {
        const bnfid = 'ark:/12148/' + id;

        r[bnfid] = (bnfid in bnfMappings) ? bnfMappings[bnfid] : null;

        return r;
      }, {})
    });
  });

  app.use('/api/v1/bnf', v1BnfRouter);
};
