import * as constants from 'corpus-common-addon/utils/constants';

import ResolverService from 'corpus-common-addon/services/resolver-service';

export default ResolverService.extend({

  storeKeyBase: 'geonames',
  apiPath: '/api/v1/resolvers/geonames/',
  resDocRoot: 'geonamesids',

  init() {
    this._super(...arguments);
  },

  processId: function(id) {
    var geonamesId = id;
    var m = id.match(constants.GEONAMES_BASE_URLS);
    if (m) {
      geonamesId = id.slice(m[0].length);
    }
    return geonamesId.replace(/\/+$/, '');
  },

  getReturnDictKey: function(id) { return id; },

  getLabel: function(id) { return this.getName(id); }

});
