import Ember from 'ember';
import * as constants from 'corpus-common-addon/utils/constants';
import layout from '../templates/components/doc-location';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',

  geonamesResolver: Ember.inject.service(),

  _resolveGeonamesIds: Ember.on('init', Ember.observer('url', function() {
    this.get('geonamesResolver').getLabel(this.get('url')).then(function(str) {
      this.set('resolvedLabel', str);
    }.bind(this));
  })),

  code: Ember.computed('url', function() {
    var rawLocation = this.get('url');
    var m = rawLocation.match(constants.GEONAMES_BASE_URLS);

    if (m) {
      rawLocation = rawLocation.slice(m[0].length);
    }

    return rawLocation.replace(/\/+$/, '');
  }),
  isLocationLink: Ember.computed.match('url', /^http:\/\//)

});
