import RESTAdapter from 'ember-data/adapters/rest';
import ENV from 'app-client/config/environment';

const TYPE_PATH_MAP = {
    transcript: 'transcript',
    geostat: 'stats/geostats',
    theme: 'stats/themes'
};

export default RESTAdapter.extend({

    namespace: (ENV.APP.backRootURL || ENV.rootURL).replace(/\/$/,"")+'/api/v1',

    buildURL: function(modelName, id) {
        if(modelName === 'transcript') {
            return this.urlPrefix() + '/documents/' + encodeURIComponent(encodeURIComponent(id)) + '/' + modelName;
        } else if (modelName === 'document' && id) {
            return this.urlPrefix() + '/documents/' + encodeURIComponent(encodeURIComponent(id)) ;
        }
        return this._super(...arguments);
    },

    pathForType: function(modelName) {
        return TYPE_PATH_MAP[modelName] || this._super(...arguments);
    }

});
