import Ember from 'ember';

export default Ember.Component.extend({
  tagName: 'li',

  classNames: ['sentence'],
  classNameBindings: ['isPlaying:active'],

  begin: Ember.computed.readOnly('turn.begin'),
  end: Ember.computed.readOnly('turn.end'),
  title: Ember.computed.readOnly('turn.title'),
  annotations: Ember.computed.readOnly('turn.annotations'),

  isPlaying: Ember.computed("player.progress", "begin", "end", function() {
    var progress = this.get('player.progress');
    return progress && progress >= this.get('begin') && progress < this.get('end');
  })
});
